package cn.freemud.entities.vo.order;

import cn.freemud.enums.OrderConfigEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @description:
 * @author: chengfeixiang<feixiang.cheng @ freemud.cn>
 * @date: 2022/1/25 15:04
 * @version: v1.0
 * @copyright: 2022 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class GetOrderConfigRequestVo {

    @NotBlank(message = "请先授权登陆")
    @ApiModelProperty("用户登陆的session")
    private String sessionId;

    @ApiModelProperty("商户号")
    @NotBlank(message = "partnerId必填")
    private String partnerId;

    @ApiModelProperty("小程序Id")
//    @NotBlank(message = "miniAppId不能为空！")
    private String miniAppId;

    /** {@link OrderConfigEnum} */
    @ApiModelProperty("获取餐盒费配置填：packAmountType")
    private String type;

}
