package cn.freemud.entities.dto;

import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: CouponCodeVerificationReqVO
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: biao.zhang
 * @date: 2018/7/17 14:45
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class CouponCodeVerificationDto extends CouponCodeBaseDto {

    /**
     * 流水号
     */
    private String trans_id;

    /**
     * 核销时间：yyyy-MM-dd
     */
    private String business_date;

    /**
     * 渠道，例如:pickup,delivery
     */
    private String channel;

    /**
     * 会员编号
     */
    private String memberId;

    /**
     * 订单金额：订单总金额（未使用优惠时）
     */
    private Long orderTotalAmount;

    /**
     * 实付金额：支付时的合计金额
     */
    private Long orderPaymentAmount;

    /**
     * 优惠金额：餐饮订单中的【商家优惠】金额
     */
    private Long orderDiscountAmount;

    /**
     * 核销交易信息
     */
    private List<CouponCodeVerificationTransDto> transactions;

}