package com.freemud.application.sdk.api.ordercenter.request;

import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: BatchQueryAfterSalesReq
 * @Package com.freemud.application.sdk.api.ordercenter.request
 * @Description:
 * @author: yuhao.chi
 * @date: 2019/6/11 13:45
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class BatchQueryAfterSalesReq {
    /**
     * 售后单状态，多个状态同时查询
     */
    private List<Integer> afterSalesStatues;
    /**
     * 分页大小
     */
    private Integer count;
    /**
     * 订单创建开始时间戳（单位：毫秒）
     */
    private Long startTimestamp;
    /**
     * 订单创建结束时间戳（单位：毫秒）
     */
    private Long endTimestamp;
    /**
     * 下单渠道 1:自营微信小程序 2:SAAS,i应用 3:自营支付宝小程序 4:自营H5 5:自营安卓APP 6:自营苹果APP 7:自营PC-WEB
     * 8:饿了么 9:饿百 10:京东 11:美团外卖 12:自营APP 13:i应用会员 14:i应用订货 15:POS
     */
    private List<Integer> orderClients;
    /**
     * 商户编号
     */
    private String partnerId;
    /**
     * 门店编号
     */
    private String storeId;
    /**
     *版本号
     */
    private String ver;

}
