package com.freemud.sdk.api.assortment.order.adapter;

import com.freemud.application.sdk.api.ordercenter.request.OrderTraceInfoResp;
import com.freemud.application.sdk.api.ordercenter.response.BaseResponse;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.*;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import com.freemud.sdk.api.assortment.order.response.order.QueryRelatedOrderByCodeResp;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: OrderSdkAdapterTest
 * @Package com.freemud.sdk.api.assortment.order.adapter
 * @Description: 简单描述下这个类是做什么用的
 * @author: dingda.li
 * @date: 2019-07-26 20:04
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */

public class OrderSdkAdapterTest {
    @Test
    public void convent2QueryFatherOrderInfo() {

        OrderSdkAdapter orderSdkAdapter = new OrderSdkAdapter();

        BaseResponse<List<OrderInfoReqs>> baseResponse = new BaseResponse<>();

        List<OrderInfoReqs> list = new ArrayList<>();
        OrderInfoReqs orderInfoReqs = new OrderInfoReqs();
        orderInfoReqs.setAbnormalDesc("12314123");
        orderInfoReqs.setAbnormalState(123);
        orderInfoReqs.setParentCode("12314123");
        orderInfoReqs.setIsParent(true);
        orderInfoReqs.setAfterSalesState(123);
        orderInfoReqs.setIsNeedInvoice(true);
        orderInfoReqs.setIsImmediately(true);
        orderInfoReqs.setCancelReason("12314123");
        orderInfoReqs.setPrintTime("12314123");
        orderInfoReqs.setAcceptTime("12314123");
        orderInfoReqs.setActualArrivalTime("12314123");
        orderInfoReqs.setPickUpTime("12314123");
        orderInfoReqs.setCreateTime("12314123");
        orderInfoReqs.setUpdateTime("12314123");
        orderInfoReqs.setUpdateTimestamp(12314123L);
        orderInfoReqs.setOrderCode("12314123");
        orderInfoReqs.setPartnerId("12314123");
        orderInfoReqs.setPartnerName("12314123");
        orderInfoReqs.setStoreId("12314123");
        orderInfoReqs.setStoreName("12314123");
        orderInfoReqs.setStoreUnifyId("12314123");
        orderInfoReqs.setToStoreId("12314123");
        orderInfoReqs.setUserId("12314123");
        orderInfoReqs.setUserName("12314123");
        orderInfoReqs.setOrderState(0);
        orderInfoReqs.setOrderSubState(1);
        orderInfoReqs.setOrderType(2);
        orderInfoReqs.setPayState(1);
        orderInfoReqs.setPayType(3);
        orderInfoReqs.setPayRequestNo("12314123");
        orderInfoReqs.setPayChannel("12314123");
        orderInfoReqs.setPayChannelName("12314123");
        orderInfoReqs.setDeliveryState(2);
        orderInfoReqs.setOriginalAmount(new BigDecimal("123"));
        orderInfoReqs.setSettlementAmount(new BigDecimal("123"));
        orderInfoReqs.setActualPayAmount(new BigDecimal("123"));
        orderInfoReqs.setNeedInvoice(true);
        orderInfoReqs.setOrderClient(1);
        orderInfoReqs.setCompanySelfCode("12314123");
        orderInfoReqs.setThirdOrderCode("12314123");
        orderInfoReqs.setNote("12314123");
        orderInfoReqs.setExtInfo("12314123");
        orderInfoReqs.setPickUpGoodsNo("12314123");
        orderInfoReqs.setDaySeq(1);
        orderInfoReqs.setMarketingType(2);
        orderInfoReqs.setMarketingCode("12314123");
        orderInfoReqs.setExpressType(1);
        orderInfoReqs.setExpressChannelName("12314123");
        orderInfoReqs.setExpressChannelCode("12314123");
        orderInfoReqs.setExpressNo("12314123");
        orderInfoReqs.setWeight(new BigDecimal("123"));
        orderInfoReqs.setCanRefund(true);
        orderInfoReqs.setPayTime("12314123");
        orderInfoReqs.setDeliveryTime("12314123");
        orderInfoReqs.setReceiveTime("12314123");
        orderInfoReqs.setBarCounter("12314123");
        orderInfoReqs.setPosCode("12314123");
        orderInfoReqs.setDinersNumber(2);
        orderInfoReqs.setLocalTableKey("12314123");
        orderInfoReqs.setPosTableKey("12314123");
        orderInfoReqs.setExpectTime("12314123");
        orderInfoReqs.setPrintNum(1);
        orderInfoReqs.setBizType(1);
        orderInfoReqs.setSuspendState(0);
        orderInfoReqs.setSuspendDesc("12314123");
        orderInfoReqs.setDeliveryPromise(new Short("12"));
        orderInfoReqs.setEstimateDeliveryCompleteTime("12314123");
        //orderInfoReqs.setOrderInvoice("12314123");
        orderInfoReqs.setOrderItemList(new  ArrayList<OrderItemResp>());
        orderInfoReqs.setDeliveryContactInfoList(new ArrayList<DeliveryContactInfoResp>());
        orderInfoReqs.setOrderCostDetailList(new ArrayList<OrderCostResp>());
        orderInfoReqs.setOrderSettlementDetailList(new ArrayList< OrderSettlementResp >());
        List<AfterSalesOrderResp> list1 = new ArrayList<AfterSalesOrderResp >();
        AfterSalesOrderResp afterSalesOrderResp = new AfterSalesOrderResp();
        afterSalesOrderResp.setActualAmount(1);
        afterSalesOrderResp.setAdultRemark("11111");
        afterSalesOrderResp.setAfterSalesCode("11111");
        afterSalesOrderResp.setAfterSalesReason("11111");
        afterSalesOrderResp.setAfterSalesStatus(2);
        afterSalesOrderResp.setAfterSalesType(3);
        afterSalesOrderResp.setCreateTime("11111");
        afterSalesOrderResp.setExpressChannelCode("11111");
        afterSalesOrderResp.setExpressChannelName("11111");
        afterSalesOrderResp.setExpressNo("11111");
        afterSalesOrderResp.setExtInfo("11111");
        afterSalesOrderResp.toString();
        list1.add(afterSalesOrderResp);
        orderInfoReqs.setAfterSalesOrderList(list1);
        orderInfoReqs.setOrderOperationHistoryList(new ArrayList<> ());
        orderInfoReqs.setOrderArea("12314123");
        orderInfoReqs.setDispenseStatus(1);
        orderInfoReqs.setImmediately(true);
        list.add(orderInfoReqs);

        baseResponse.setCode("100");
        baseResponse.setMessage("成功");
        baseResponse.setResult(list);

        QueryRelatedOrderByCodeResp queryRelatedOrderByCodeResp = orderSdkAdapter.convent2QueryFatherOrderInfo(baseResponse);

        List<QueryOrdersResponse.DataBean.OrderBean> lists = queryRelatedOrderByCodeResp.getOrderBeanList();

        assert(lists.size() == 1);

        QueryOrdersResponse.DataBean.OrderBean orderBean = lists.get(0);

        assert("12314123".equals(orderBean.getThirdOrderCode()));

        assert(orderBean.getAfterSalesOrderResp() != null);
    }
}