package cn.freemud.entities.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class PremiumExchangeRequestVo {

    @ApiModelProperty(value="版本号", name="version", example="1", required = false)
    private String version;

    @NotNull(message = "partnerId不能为空")
    @ApiModelProperty(value="商户号", name="partnerId", example="1864", required = true)
    private String partnerId;

    @NotNull(message = "shopId不能为空")
    @ApiModelProperty(value="门店ID", name="shopId", example="007", required = true)
    private String shopId;

    @NotNull(message = "用户会话sessionId不能为空")
    @ApiModelProperty(value="sessionId", name="sessionId", example="1234", required = true)
    private String sessionId;

    /**
     * 订单类型  1 到店自取 2 外卖   枚举CreateOrderType
     */
    @NotNull(message = "orderType 不能为空")
    @ApiModelProperty(value="订单类型 1到店自取 2外卖", name="orderType", example="1", required = true)
    private Integer orderType;

    @ApiModelProperty(value="券code", name="couponCode", example="258655672617402368", required = false)
    private String couponCode;
    /**
     * 优惠券的活动code
     */
    @ApiModelProperty(value="优惠券的活动code", name="activityCode", example="258655672617402368", required = false)
    private String activityCode;

    /**
     * 菜单类型 saas(开个店自提)、saasdelivery（开个店外卖）
     */
    @ApiModelProperty(value="菜单类型 saas(开个店自提)、saasdelivery（开个店外卖）", name="menuType", example="saas", required = false)
    @NotNull(message = "menuType 不能为空")
    private String menuType;

    /**
     * 业务类型 7-预定单  爱马哥蛋糕预定场景使用(2.0.41迭代 1032929)
     */
    private Integer bizType;

    /**
     * 优惠券code列表
     */
    private List<couponCode> couponCodes;

    @Data
    public final static class couponCode {
        /**
         * 优惠券
         */
        private String couponCode;
        /**
         * 活动号
         */
        private String activityCode;

        /**
         * 顺序
         */
        private Integer index;

        /**
         * 优惠券类型
         */
        private Integer couponType;
    }

}
