/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: RedisKeyConstant
 * @Package cn.freemud.constant
 * @Description: redisKey相关的常量
 * @author: song.cai
 * @date: 2018/12/17 12:48
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.constant;

import com.freemud.application.sdk.api.ordercenter.common.OrderAndShoppingCommonRedisKey;

public class RedisKeyConstant {
    /**
     * userInfoMap的redisKey前缀
     */
    public final static String SAAS_USER_INFO_SESSIONID_KEY_PREFIX = "saas:user:info:sessionId:";
    /**
     * 手机号验证码的redisKey前缀
     */
    public final static String SAAS_VERIFICATION_CODE_KEY_PREFIX = "saas:userSmsCode:mobile_";
    /**
     * 用户购物车在redis的key前缀 弃用
     * @see  OrderAndShoppingCommonRedisKey
     */
    @Deprecated
    public final static String SAAS_SHOPPINGCART_KEY_PREFIX = "saas:user:info:cart:goods:";
    /**
     * 用户购物车在redis的key前缀  爱马哥蛋糕预定 弃用
     * @see  OrderAndShoppingCommonRedisKey
     */
    @Deprecated
    public final static String SAAS_SHOPPINGCART_AIMAGE_KEY_PREFIX = "saas:user:info:advance:cart:goods:";
    /**
     * 用户购物车总价在redis的key前缀
     */
    public final static String SAAS_SHOPPINGCART_AMOUNT_PREFIX = "saas:user:info:cart:amount:goods:";
    /**
     * 商品的信息前缀
     */
    public final static String SAAS_GOODS_KEY_PREFIX = "saas:goods:";
    /**
     * 智慧推荐存商品在redis的key前缀
     */
    public final static String SAAS_USER_INFO_CNXH = "saas:user:info:cnxh:";
    /**
     * 校验用户登录白名单在redis的key前缀
     */
    public final static String SAAS_NOT_FILTER_URL = "saas:micro:exclude:url:";
    /**
     * 新版支付白名单在redis的key前缀
     */
    public final static String SAAS_MICRO_PAYMENT_PARTNER = "saas:micro:payment:partner:";

    /**
     * wxapp_config配置表
     */
    public final static String KGD_ORDER_OPEN_STORE_IAPP_WXAPP_CONFIG_WXAPPID_ = "kgd:order:open_store_iapp_wxapp_config:wxappid_";
}
