package cn.freemud.enums.integralproduct;

public enum IntegralProductStatusEnum {

    /**
     * 商品状态（1下架，2上架，3售罄，4不在可售时间内，5超过每人总限购数量，6超过每人每天限购数量，7用户等级不足，8用户身份不足）
     */
    STATUS_1(1, "下架"),
    STATUS_2(2, "上架"),
    STATUS_3(3, "售罄"),
    STATUS_4(4, "不在可售时间内"),
    STATUS_5(5, "超过每人总限购数量"),
    STATUS_6(6, "超过每人每天限购数量"),
    STATUS_7(7, "用户等级不足"),
    STATUS_8(8, "用户身份不足");

    private Integer code;

    private String desc;

    IntegralProductStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static IntegralProductStatusEnum getByCode(Integer code) {
        for (IntegralProductStatusEnum statusEnum : values()) {
            if (statusEnum.getCode().equals(code)) {
                return statusEnum;
            }
        }
        return null;
    }

}
