/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderController
 * @Package cn.freemud.controller
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/17 17:14
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.controller;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.*;
import cn.freemud.entities.vo.encircle.CreateReserveOrderVo;
import cn.freemud.entities.vo.encircle.EmptyTableNumberVo;
import cn.freemud.entities.vo.encircle.EncircleReserveBaseVo;
import cn.freemud.monitorcenter.tools.HealthUtil;
import cn.freemud.service.EncircleOrderService;
import cn.freemud.service.OrderAdapterService;
import cn.freemud.service.Orderservice;
import cn.freemud.utils.ResponseUtil;
import cn.freemud.service.impl.MallOrderServiceImpl;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import com.freemud.sdk.api.assortment.order.response.order.CreateOrderResponse;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RequestMapping("/order")
@RestController
@Validated
public class OrderController {

    @Autowired
    private Orderservice orderservice;
    @Autowired
    private OrderAdapterService orderAdapterService;
    @Autowired
    private EncircleOrderService encircleOrderService;
    @Autowired
    private MallOrderServiceImpl mallOrderService;

    /**
     * 创建订单之前校验前面排队的订单数
     */
    @ApiAnnotation(logMessage = "checkBeforeCreateOrder")
    @PostMapping("/checkBeforeCreateOrder")
    public BaseResponse checkBeforeCreateOrder(@Validated @LogParams @RequestBody CheckBeforeCreateOrderRequestVo checkBeforeCreateOrderRequestVo) {
        long start = System.currentTimeMillis();
        BaseResponse result = null;
        try {
            result = orderservice.checkBeforeCreateOrder(checkBeforeCreateOrderRequestVo);
        } catch (Exception e) {
            HealthUtil.logHealthInfo("checkBeforeCreateOrder", (System.currentTimeMillis() - start), e.getMessage());
        }
        return result;
    }

    /**
     * 创建订单
     */
    @ApiAnnotation(logMessage = "createOrder")
    @PostMapping("/createOrder")
    public BaseResponse createOrder(@Validated @LogParams @RequestBody CreateOrderVo createOrderVo) {
        return orderAdapterService.createOrderNew(createOrderVo);
    }

    /**
     * 扫脸支付下单
     */
    @ApiAnnotation(logMessage = "scanFaceCreateOrder")
    @PostMapping("/scanFaceCreateOrder")
    public BaseResponse scanFaceCreateOrder(@Validated @LogParams @RequestBody CreateOrderVo createOrderVo) {
        return orderservice.scanFaceCreateOrder(createOrderVo);
    }

    /**
     * APP下单，下单带商品信息，不经过购物车服务，不唤起支付
     */
    @ApiAnnotation(logMessage = "appCreateOrder")
    @PostMapping("/app/create")
    public BaseResponse appCreateOrder(@Validated @LogParams @RequestBody AppCreateOrderVo createOrderVo) {
        return orderAdapterService.appCreateOrder(createOrderVo);
    }

    /**
     * 订单支付成功后通知
     */
    @ApiAnnotation(logMessage = "paySuccessCallback")
    @PostMapping("/paySuccessCallback")
    public String paySuccessCallback(@LogParams @RequestBody PaysuccessNoticeMessage message) {
        return orderAdapterService.paySuccessCallback(message);
    }

    /**
     * 订单支付成功后通知
     */
    @ApiAnnotation(logMessage = "newPaySuccessCallback")
    @PostMapping({"/newPaySuccessCallback","/openStoreQueryPaymentCallback"})
    public String newPaySuccessCallback(@LogParams @RequestBody NewPaysuccessNoticeMessage message) {
        return orderservice.newPaySuccessCallback(message);
    }

    /**
     * 退款回掉通知
     */
    @ApiAnnotation(logMessage = "refundNotifyCallback")
    @PostMapping("/refundNotifyCallback")
    public String refundNotifyCallback(@LogParams @RequestBody RefundNotifyCallbackRequestVo requestVo) {
        return orderservice.refundNotifyCallback(requestVo);
    }

    /**
     * 查询订单列表
     */
    @ApiAnnotation(logMessage = "queryOrders")
    @PostMapping("/queryOrders")
    public BaseResponse queryOrders(@Validated @LogParams @RequestBody QueryOrderVo queryOrderVo) {
        return orderservice.queryOrders(queryOrderVo);
    }

    /**
     * 围餐-预览订单
     * @param queryOrderVo
     * @return
     */
    @ApiAnnotation(logMessage = "previewOrderInfo")
    @PostMapping("/previewOrderInfo")
    public BaseResponse previewOrderInfo(@Validated @LogParams @RequestBody QueryOrderVo queryOrderVo){
        CreateReserveOrderVo createReserveOrderVo =  new CreateReserveOrderVo();
        createReserveOrderVo.setSessionId(queryOrderVo.getSessionId());
        return encircleOrderService.queryOrderInfo(createReserveOrderVo);
    }

    /**
     * 获取订单详情
     */
    @ApiAnnotation(logMessage = "queryOrderById")
    @PostMapping("/queryOrderById")
    public BaseResponse queryOrderById(@Validated @LogParams @RequestBody QueryOrderVo queryOrderVo) {
        return orderservice.queryOrderById(queryOrderVo.getOperation(),queryOrderVo.getSessionId(), queryOrderVo.getOid(),queryOrderVo.getPartnerId(),queryOrderVo.getChannelType());
    }

    /**
     * 取消支付删除订单
     */
    @ApiAnnotation(logMessage = "deleteOrder")
    @PostMapping("/deleteOrder")
    public BaseResponse deleteOrder(@Validated @LogParams @RequestBody DeleteOrderVo deleteOrderVo) {
        return orderservice.deleteOrder(deleteOrderVo);
    }

    /**
     * 用户申请退款
     */
    @ApiAnnotation(logMessage = "refund")
    @PostMapping("/refund")
    public BaseResponse refund(@Validated @LogParams @RequestBody OrderRefundVo orderRefundVo) {
        return orderservice.orderRefund(orderRefundVo);
    }

    /**
     * 获取订单排队号
     */
    @ApiAnnotation(logMessage = "queueIndex")
    @PostMapping("/queueIndex")
    public BaseResponse getOrderQueueIndex(@Validated @LogParams @RequestBody QueryOrderQueueIndexVo queryOrderQueueIndexVo) {
        return orderservice.queryOrderQueueIndex(queryOrderQueueIndexVo);
    }


    /**
     * 获取申请退款理由 1.9后作废
     */
    @ApiAnnotation(logMessage = "getOrderRefundReason")
    @ApiOperation(value = "获取申请退款理由", notes = "获取申请退款理由", produces = "application/json")
    @PostMapping("/getOrderRefundReason")
    public BaseResponse getRefundReason(@LogParams @RequestBody GetRefundReasonVo getRefundReasonVo) {
        return orderservice.getRefundReason(getRefundReasonVo);
    }

    /**
     * 获取申请退款理由
     */
    @ApiAnnotation(logMessage = "getNewOrderRefundReason")
    @ApiOperation(value = "获取申请退款理由", notes = "获取申请退款理由", produces = "application/json")
    @PostMapping("/getNewOrderRefundReason")
    public BaseResponse getNewRefundReason(@LogParams @RequestBody GetRefundReasonVo getRefundReasonVo) {
        return orderservice.getNewRefundReason(getRefundReasonVo);
    }

    /**
     * 查询桌号是否开台
     */
    @ApiAnnotation(logMessage = "queryTableNumberStatus")
    @ApiOperation(value = "查询桌号是否开台", notes = "查询桌号是否开台", produces = "application/json")
    @PostMapping("/queryTableNumberStatus")
    public BaseResponse queryTableNumberStatus(@LogParams @RequestBody EncircleReserveBaseVo encircleReserveBaseVo) {
        return encircleOrderService.queryTableNumberStatus(encircleReserveBaseVo);
    }

    /**
     * 查询30分钟未支付的优惠券订单
     */
    @ApiAnnotation(logMessage = "queryOrderWithCoupon")
    @ApiOperation(value = "查询30分钟未支付的优惠券订单", notes = "查询30分钟未支付的优惠券订单", produces = "application/json")
    @PostMapping("/queryOrderWithCoupon")
    public BaseResponse queryOrderWithCoupon(@LogParams @RequestBody QueryOrderWithCouponVo orderWithCouponVo) {
        return ResponseUtil.success();
    }

    /**
     * 订单确认完成
     */
    @ApiAnnotation(logMessage = "affirm")
    @PostMapping("/affirm")
    public BaseResponse orderAffirm(@Validated @LogParams @RequestBody OrderAffirmRequestVO request) {
        return mallOrderService.orderAffirm(request);
    }

    /**
     * 创建预支付
     */
    @ApiAnnotation(logMessage = "createPrepay")
    @PostMapping("/createPrepay")
    public BaseResponse createPrepay(@Validated @LogParams @RequestBody CreatePrepayVo request) {
        return orderAdapterService.createPrepay(request);
    }

    /**
     * mock支付回调
     * 此方法不发布到生产环境，只在测试做联调测试
     */
    @ApiAnnotation(logMessage = "mockPayCallback")
    @PostMapping("/mockPayCallback")
    public String mockPayCallback(@LogParams @RequestBody NewPaysuccessNoticeMessage message) {
        return orderservice.newPaySuccessCallback(message);
    }

}
