package cn.freemud.service.impl;

import cn.freemud.amp.config.OrderCallBackConfig;
import cn.freemud.amqp.Header;
import cn.freemud.amqp.MQMessage;
import cn.freemud.amqp.MQService;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.base.log.LogTreadLocal;
import cn.freemud.base.util.DateUtil;
import cn.freemud.entities.vo.PushInvoiceRequestVo;
import cn.freemud.service.ToolsService;
import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.ordercenter.request.OrderConditionsReq;
import com.freemud.application.sdk.api.ordercenter.response.BaseDownLoadResponse;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInfoReqs;
import com.freemud.application.sdk.api.ordercenter.service.OrderDownLoadSdkService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: cn.freemud.service.impl ToolsServiceImpl
 * @Description: TDO 描述....
 * @author: family
 * @date: 2020/4/22
 * @Copyright: www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
public class ToolsServiceImpl implements ToolsService {

    @Autowired
    private OrderDownLoadSdkService orderDownLoadSdkService;

    @Autowired
    private MQService mqService;

    @Override
    public BaseResponse push(PushInvoiceRequestVo requestVo) {

        long start = DateUtil.getTimestamp(requestVo.getStartTime(), DateUtil.FORMAT_YYYY_MM_DD_HHMMSS);
        long end  = DateUtil.getTimestamp(requestVo.getEndTime(), DateUtil.FORMAT_YYYY_MM_DD_HHMMSS);
        OrderConditionsReq req = new OrderConditionsReq();
        req.setPartnerId(requestVo.getPartnerId());
        req.setStartTimestamp(start/1000);
        req.setEndTimestamp(end/1000);
        req.setPayStatuses(Arrays.asList(2));
        req.setBizType(1);
        req.setPageSize(1);
        req.setPageNum(1);
        if (requestVo.getOrderCodes()!=null) {
            req.setOrderCodes(requestVo.getOrderCodes());
        }

        BaseDownLoadResponse<List<OrderInfoReqs>> response = orderDownLoadSdkService.queryOrderByConditions(req, LogThreadLocal.getTrackingNo());
        if (!"100".equals(response.getCode()) || response.getResult()==null) {
            return new BaseResponse("1","1","查询Es数据失败");
        }
        if (response.getTotalNum()==0) {
            return new BaseResponse("1","100","在ES没查询到数据.");
        }

        //订单总数
        Integer orderTotal = response.getTotalNum();
        if (!"1".equals(requestVo.getSend())) {
            return new BaseResponse("1","100","符合条件的订单数据："+orderTotal+"条");
        }
        int        pageSize  = 500;
        int        pageTotal = (int) Math.ceil((double) orderTotal / (double) pageSize);
        for (int i=0;i<pageTotal;i++) {
            req.setPageSize(pageSize);
            req.setPageNum(i+1);
            response = orderDownLoadSdkService.queryOrderByConditions(req, LogTreadLocal.getTrackingNo());
            for (OrderInfoReqs reqs : response.getResult()) {
                Header header = new Header("report", "call-back-service-api",
                        OrderCallBackConfig.INVOICE_ROUTE_KEY, OrderCallBackConfig.INVOICE_QUEUE);

                MQMessage<String> message = new MQMessage<>(header, JSON.toJSONString(reqs));
                mqService.convertAndSend(OrderCallBackConfig.TOPIC_EXCHANGE_NAME, OrderCallBackConfig.INVOICE_ROUTE_KEY, message);
            }
        }
        return new BaseResponse("1","100","写入MQ："+orderTotal);
    }
}
