package cn.freemud.service.impl.mcoffee.calculation;

import cn.freemud.adapter.ShoppingCartMccafeAdapter;
import cn.freemud.entities.dto.ActivityCalculationDiscountResponseDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.ActivityList;
import cn.freemud.entities.vo.ActivityTip;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.entities.vo.ShoppingCartGoodsResponseVo;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.utils.MoneyUtils;
import com.google.common.base.Functions;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
public class BuySendCalculation {

    @Autowired
    private ShoppingCartMccafeAdapter shoppingCartMccafeAdapter;

    public void updateBuySendActivityTip(ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult, ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo, List<CartGoods> cartSendGoodsList) {

        if(CollectionUtils.isNotEmpty(calculationDiscountResult.getActivityPrompts())) {
            List<ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ActivityPrompt> activityPromptList = calculationDiscountResult.getActivityPrompts().stream().filter(o -> ActivityTypeEnum.TYPE_230.getCode().equals(o.getActivityType())).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(activityPromptList)) {
                ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ActivityPrompt activityPrompt = activityPromptList.get(0);
                ActivityTip activityTip = shoppingCartGoodsResponseVo.getActivityTip();
                if(activityTip == null) {
                    activityTip = new ActivityTip();
                    shoppingCartGoodsResponseVo.setActivityTip(activityTip);
                }
                if(CollectionUtils.isEmpty(activityTip.getActivityList())) {
                    activityTip.setActivityList(new ArrayList<ActivityList>());
                }
                ActivityList activityList = new ActivityList();
                activityList.setTipType(activityPrompt.getActivityType());
                activityList.setSatisfy(MoneyUtils.parseFen2Yuan(activityPrompt.getThresholdAmount()));
                if(activityPrompt.getThresholdAmount() > activityPrompt.getTotalAmount()) {
                    activityList.setMissing(MoneyUtils.parseFen2Yuan(activityPrompt.getThresholdAmount() - activityPrompt.getTotalAmount()));
                    activityList.setAgainBuy(MoneyUtils.parseFen2Yuan(activityPrompt.getThresholdAmount() - activityPrompt.getTotalAmount()));
                }
                if(CollectionUtils.isNotEmpty(activityPrompt.getSendGoods())) {
                    if (CollectionUtils.isEmpty(cartSendGoodsList)) {
                        cartSendGoodsList = new ArrayList<>();
                    }
                    Map<String, CartGoods> map = cartSendGoodsList.stream().collect(Collectors.toMap(CartGoods::getSpuId, Function.identity(), (k1, k2) -> k1));
                    List<ActivityList.McCafeSendGoods> mcCafeSendGoodsList = activityPrompt.getSendGoods().stream().map(o -> {
                        ActivityList.McCafeSendGoods mcCafeSendGoods = new ActivityList.McCafeSendGoods();
                        mcCafeSendGoods.setGoodsId(o.getGoodsId());
                        mcCafeSendGoods.setSpuName(o.getGoodsName());
                        mcCafeSendGoods.setQty(o.getSendNumber());
                        if(map.get(o.getGoodsId()) != null) {
                            mcCafeSendGoods.setIsSelected(1);
                        }
                        return mcCafeSendGoods;
                    }).collect(Collectors.toList());
                    activityList.setMcCafeSendGoodsList(mcCafeSendGoodsList);
                } else {
                    activityList.setMcCafeSendGoodsList(new ArrayList<ActivityList.McCafeSendGoods>());
                }
                activityTip.getActivityList().add(activityList);
            }
        }
    }

    public void updateBuySendGoods(ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult, ShoppingCartGoodsDto shoppingCartGoodsDto, List<CartGoods> cartSendGoodsList) {
        if(CollectionUtils.isNotEmpty(calculationDiscountResult.getSendGoods())) {
            List<ActivityCalculationDiscountResponseDto.CalculationDiscountResult.SendActivity> sendActivityList = calculationDiscountResult.getSendGoods().stream().filter(o -> ActivityTypeEnum.TYPE_230.getCode().equals(o.getActivityType())).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(sendActivityList)) {
                ActivityCalculationDiscountResponseDto.CalculationDiscountResult.SendActivity sendActivity = sendActivityList.get(0);
                if(CollectionUtils.isNotEmpty(sendActivity.getSendGoods()) && CollectionUtils.isNotEmpty(cartSendGoodsList)) {
                    Map<String, CartGoods> map = cartSendGoodsList.stream().collect(Collectors.toMap(CartGoods::getSpuId, Functions.identity(), (k1, k2) -> k1));
                    sendActivity.getSendGoods().forEach( o -> {
                        CartGoods cartGoods = map.get(o.getGoodsId());
                        if(null != cartGoods) {
                            ShoppingCartGoodsDto.CartGoodsDetailDto cartGoodsDetailDto = shoppingCartMccafeAdapter.convertCartGoods2DetailGoodsList(cartGoods, null, null);
                            cartGoodsDetailDto.setOriginalPrice(0l);
                            cartGoodsDetailDto.setSalePrice(0l);
                            cartGoodsDetailDto.setIsSendGoods(true);
                            shoppingCartGoodsDto.getProducts().add(cartGoodsDetailDto);
                        }
                    });
                }
            }
        }
    }
}
