package cn.freemud.controller;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.PushInvoiceRequestVo;
import cn.freemud.service.ToolsService;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: cn.freemud.controller ToolController
 * @Description: TDO 描述....
 * @author: family
 * @date: 2020/4/22
 * @Copyright: www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RestController
@RequestMapping(value = "/tools", consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class ToolsController {

    @Autowired
    private ToolsService toolsService;
    @PostMapping("/push")
    @ApiAnnotation(logMessage = "/push")
    public BaseResponse push(@Valid @RequestBody @LogParams PushInvoiceRequestVo requestVo) {
        return toolsService.push(requestVo);
    }
}
