/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderCenterProperties
 * @Package com.freemud.application.sdk.api.ordercenter.config
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/1 19:18
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.application.sdk.api.ordercenter.config;

import com.freemud.application.sdk.api.config.CenterConfigProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@ConfigurationProperties(prefix = "order")
public class OrderCenterProperties extends CenterConfigProperties {

    /**
     * 校验 多少时间类 从redis拿 数据 反馈es查询结果
     */
    private int redisToEsTimeLimit = 0;


    private List<String> redisToEsPartnerIds = new ArrayList<>();

    public List<String> getRedisToEsPartnerIds() {
        return redisToEsPartnerIds;
    }

    public void setRedisToEsPartnerIds(List<String> redisToEsPartnerIds) {
        this.redisToEsPartnerIds = redisToEsPartnerIds;
    }

    public int getRedisToEsTimeLimit() {
        return redisToEsTimeLimit;
    }

    public void setRedisToEsTimeLimit(int redisToEsTimeLimit) {
        this.redisToEsTimeLimit = redisToEsTimeLimit;
    }
}
