package cn.freemud.enums;

public enum  CouponIsUsedEnum {

    UNUSED(0, "未使用"),
    USED(1, "已使用");

    private Integer code;
    private String desc;

    CouponIsUsedEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CouponIsUsedEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (CouponIsUsedEnum couponIsUsedEnum : values()) {
            if (couponIsUsedEnum.getCode().equals(code)) {
                return couponIsUsedEnum;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
