///**
// * All rights Reserved, Designed By www.freemud.cn
// *
// * @Title: OrderClient
// * @Package cn.freemud.service.thirdparty
// * @Description:
// * @author: liming.guo
// * @date: 2018/5/18 11:52
// * @version V1.0
// * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
// * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
// */
//package cn.freemud.service.thirdparty;
//
//
//import cn.freemud.entities.dto.*;
//import cn.freemud.entities.dto.order.CreateOrderDto;
//import org.springframework.cloud.openfeign.FeignClient;
//import org.springframework.web.bind.annotation.*;
//
//@FeignClient(name = "ORDERSERVICE",url = "${saas.orderclient.feign.url}")
//@RequestMapping(produces = {"application/json;charset=UTF-8"})
//public interface OrderClient {
//
//    /**
//     * 创建订单
//     */
//    @PostMapping("/Order/Create")
//    CreateOrderResponseDto createOrder(@RequestBody CreateOrderDto createOrderDto);
//
//    /**
//     *  订单支付确认
//     */
//    @PostMapping("/Order/PayAccess/V2")
//    PayAccessResponse payAccess(@RequestBody ConfirmOrderDto confirmOrderDto);
//
//    /**
//     * 条件查询用户订单
//     */
//    @PostMapping("/Query/Order/ListPageByUserConditions")
//    QueryOrdersResponseDto queryOrders(@RequestBody QueryOrdersDto queryOrdersDto);
//
//    /**
//     * 根据订单ID查询订单详情
//     */
//    @GetMapping("/Query/Order/GetById")
//    QueryOrderByIdResponseDto queryOrderById(@RequestParam("orderId") String orderId);
//
//    /**
//     * 删除订单
//     */
//    @PostMapping("/Order/Delete")
//    BaseResponseDto deleteOrder(@RequestBody DeleteOrderDto deleteOrderDto);
//
//    /**
//     * 申请退款
//     */
//    @PostMapping("/Order/refundAllApply/V2")
//    BaseResponseDto orderRefund(@RequestBody OrderRefundRequestDto orderRefundRequestDto);
//
//    /**
//     * 修改订单
//     */
//    @PostMapping("Order/Edit")
//    BaseResponseDto orderEdit(@RequestBody OrderEditDto orderEditDto);
//
//    /**
//     * 取消订单
//     */
//    @PostMapping("Order/Cancel")
//    BaseResponseDto orderCancel(@RequestBody OrderCancelRequestDto orderCancelRequestDto);
//
//    /**
//     * 获取取餐排队号
//     */
//    @GetMapping("/Query/order/queueIndex/{orderId}")
//    QueryOrderQueueIndexResponse queryOrderQueueIndex(@PathVariable("orderId") String orderId);
//
//    /**
//     * 获取当前门店接单数
//     */
//    @GetMapping("/Query/order/queueSize")
//    QueryStoreOrderQuantityResponseDto queryStoreOrderQuantity(@RequestParam("companyId") String companyId, @RequestParam("shopId") String shopId);
//
//    /**
//     * 根据订单ID查询订单状态操作记录
//     */
//    @GetMapping("/Query/Order/getOrderStatusTrackingInfoByOid")
//    OrderStatusTrackingInfoDto getOrderStatusTrackingInfoByOid(@RequestParam("orderId") String orderId);
//}
