package cn.freemud.service.impl;

import cn.freemud.amp.config.DlPaymentMqConfig;
import cn.freemud.amqp.Header;
import cn.freemud.amqp.MQMessage;
import cn.freemud.amqp.MQService;
import cn.freemud.entities.dto.pay.PaymentMqMessageDto;
import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.config.TopicExchangeConfig;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PaymentQueueService {

//    @Autowired
//    private RabbitTemplate restTemplate;
    @Autowired
    private MQService mqService;


    public void paymentCallback(PaymentMqMessageDto dto){
        MQMessage<PaymentMqMessageDto> mqMessage = new MQMessage<PaymentMqMessageDto>();
        mqMessage.setBody(dto);
        Integer ttl = 20 * 1000;
        Header header=new Header();
        header.setKey("1");
        mqMessage.setHeader(header);
        byte[] notifyMsgBytes = JSON.toJSONString(mqMessage).getBytes();
        MessageProperties messageProperties = new MessageProperties();
        messageProperties.setExpiration(ttl.toString());
        messageProperties.setContentType(MessageProperties.CONTENT_TYPE_JSON);
        Message delmessage = new Message(notifyMsgBytes, messageProperties);
//        logger.info("restTemplate.convertAndSend:"+dto);
        mqService.convertAndSend(TopicExchangeConfig.EXCHANGE_NAME, DlPaymentMqConfig.OPEN_STORE_PAYMENT_QUERY_DL_KEY, delmessage);
//        restTemplate.convertAndSend(TopicExchangeConfig.EXCHANGE_NAME, DlPaymentMqConfig.OPEN_STORE_PAYMENT_QUERY_DL_KEY, delmessage);
    }
}
