package cn.freemud.service.impl.mcoffee.entity;

import cn.freemud.entities.vo.*;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: MCoffeeAddGoodsRequestVo
 * @Package cn.freemud.service.impl.mcoffee.entity
 * @Description:
 * @author: ping1.wu
 * @date: 2020/8/8 21:04
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class MCoffeeAddGoodsRequestVo {


    @NotBlank(message = "sessionId不能为空")
    private String sessionId;
    /**
     * 商户Id
     */
    @NotBlank(message = "partnerId不能为空")
    private String partnerId;

    /**
     * 微信appId
     */
    @NotBlank(message = "appId不能为空")
    private String appId;
    /**
     * 门店Id
     * 商城没有门店id，如果需要门店id必传在业务中进行校验
     */
//    @NotEmpty(message = "shopId不能为空")
    private String shopId;

    /**
     * 下单类型 CreateOrderType 外卖、到店、商城
     */
    private Integer orderType;

    /**
     * 渠道类型 OrderChannelType
     */
    private String channelType;

    @NotBlank(message = "spuId不能为空")
    private String spuId;

    private String skuId;

    private String version;

    /**
     * 1.6.0 版本增加  节点ID
     */
    private String nodeId;
    /**
     * 1.6.0 版本增加 分类名
     */
    private String categoryName;
    /**
     * 商品额外的属性
     */
    private List<CartGoods.CartGoodsExtra> extra;
    /**
     * 套餐固定商品
     */
    private List<ComboxGoodsRequestVo> productComboList;
    /**
     * 套餐可选商品
     */
    private List<ComboxGoodsRequestVo> productGroupList;

    /**
     * 加料
     */
    private List<MaterialRequestVo> productMaterialList;

    /**
     * 麦咖啡定制属性
     */
    private List<CartGoods.SpecialExtra> specialExtra;


    private String appType;

    private String tableNumber;
    /**
     * 数量
     */
    private Integer qty;

    /**
     * 业务类型： 0 : 自提 1：外卖 2：微商城
     */
    private String menuType ;

    /**
     * 收货地址ID、svc卡支付外卖订单必传
     */
    private String receiveId;

    /**
     * 操作类型 1= 添加商品券 2=加价购
     */
    private Integer operationType;

    /**
     * 券类型 0：商品券
     */
    private Integer couponType;
    /**
     * 商品券门槛金额
     */
    private Long couponThresholdAmount;

    /**
     * 是否是太阳蛋商品
     */
    private int isSunnyCoupon = 0;

    /**
     * 优惠券号
     */
    private String couponCode;

    /**
     * 套餐名称
     */
    private String groupName;

    /**
     * 当前商品是否为月享卡，0:否，1:是
     */
    private int isMonthCard;
    /**
     * 是否为月享卡商品
     */
    private int isMonthCardGoods;

    private int isB3S1Coupon;
    /**
     * 月享卡加购信息
     */
    private MonthCardVo monthCardInfo;
    /**
     * 买3赠1券商品信息
     */
    private B3S1CouponGoodsInfoVo b3S1CouponGoodsInfo;

}
