package cn.freemud.demo.adapter.service;

import cn.freemud.demo.entities.ShoppingCartGoodsBO;
import cn.freemud.demo.entities.bo.goods.list.ListCartGoodsBO;
import cn.freemud.demo.entities.bo.goods.list.ListCartGoodsVO;
import cn.freemud.demo.entities.bo.goods.list.PlatformListCartGoodsBO;
import cn.freemud.demo.entities.dto.goods.add.BaseAddGoodsVO;
import cn.freemud.demo.entities.dto.goods.add.MCoffeeAddGoodsVO;
import cn.freemud.demo.entities.dto.goods.add.PlatformAddGoodsVO;
import cn.freemud.demo.entities.dto.goods.add.list.BaseListCartGoodsVO;
import cn.freemud.demo.entities.dto.goods.add.list.MCoffeeListCartGoodsVO;
import cn.freemud.demo.entities.dto.goods.add.list.PlatformListCartGoodsVO;
import cn.freemud.demo.enums.BizTypeEnum;
import cn.freemud.utils.BeanUtil;
import ma.glasnost.orika.MapperFacade;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class ListCartGoodsVOAdapter {

    @Resource
    private MapperFacade mapperFacade;

    public BaseListCartGoodsVO convert2ListCartGoodsVO(String bizType, ShoppingCartGoodsBO baseAddGoodsBO) {
        BaseListCartGoodsVO listCartGoodsVO;
        if (BizTypeEnum.MCOFFEE.getCode().equals(bizType)) {
            listCartGoodsVO = createMCoffeeVO(baseAddGoodsBO);
        } else {
            listCartGoodsVO = createPlatformVO(baseAddGoodsBO);
        }
        return listCartGoodsVO;
    }


    private PlatformListCartGoodsVO createPlatformVO(ShoppingCartGoodsBO baseAddGoodsBO) {

        PlatformListCartGoodsVO platformAddGoodsVO = BeanUtil.convertBean(baseAddGoodsBO, PlatformListCartGoodsVO::new);
        return platformAddGoodsVO;
    }

    private MCoffeeListCartGoodsVO createMCoffeeVO(ShoppingCartGoodsBO baseAddGoodsBO) {
        MCoffeeListCartGoodsVO mCoffeeAddGoodsVO = new MCoffeeListCartGoodsVO();
        return mCoffeeAddGoodsVO;
    }


}
