package cn.freemud.entities.vo.coupon;

import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: cn.freemud.entities.vo.coupon Product
 * @Description: TDO 描述....
 * @author: family
 * @date: 2020/6/30
 * @Copyright: www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class CartProduct {
    /**
     * 商品id
     */
    private String productId;
    /**
     * 商品原价（分）
     */
    private Long originalPrice;
    /**
     * 总原价金额(包括主商品+可选搭配+加料商品)
     */
    private Long originalTotalAmount;
    /**
     * 总实付金额(包括主商品+可选搭配+加料商品)
     */
    private Long realAmount;

    //总优惠金额(不包括赠品优惠金额和套餐优惠金额)
    private Long discountAmount;
    /**
     * 主商品数量
     */
    private Integer quantity;

    //使用的商品券号
    private String couponCode;

    private List<Discount> discounts;

    @Data
    public static class Discount{

        /**
         * 活动号
         */
        private String activityCode;

        /**
         * 活动名称
         */
        private String activityName;

        /**
         * 折扣金额
         */
        private Long discount;

        /**
         * 活动类型
         */
        private Integer type;

        /**
         * 当前活动实际优惠的商品数量
         */
        private Integer actualGoodsNumber;

        //是否与代金券互斥
        private boolean cashExclusive = false;

        //是否与代金券叠加门槛
        private boolean cashMultiple = true;

        //是否与折扣券互斥
        private boolean discountExclusive = false;

        //是否与折扣券叠加门槛
        private boolean discountMultiple = true;
    }
}
