package cn.freemud.management.controller;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.management.entities.dto.request.delivery.DeliveryOrderRequest;
import cn.freemud.management.service.impl.OrderDeliveryService;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 创建配送单
 */
@RequestMapping("/order")
@RestController

@Validated
public class DeliveryOrderController {

    @Autowired
    private OrderDeliveryService orderDeliveryService;

    @ApiAnnotation(logMessage = "deliveryCreate")
    @ApiOperation(value = "创建配送单", notes = "创建配送单", produces = "application/json")
    @GetMapping("/delivery/create")
    public BaseResponse deliveryCreate(@RequestParam("orderCode") String orderCode
            , @RequestParam(value = "operator", required = false) String operator) {
        return orderDeliveryService.createDelivery(orderCode, operator);
    }


    @ApiAnnotation(logMessage = "cancelDeliveryOrder")
    @ApiOperation(value = "取消配送单", notes = "取消配送单", produces = "application/json")
    @PostMapping("/delivery/cancel")
    public BaseResponse cancelDeliveryOrder(@Validated @LogParams @RequestBody DeliveryOrderRequest request) {
        return orderDeliveryService.cancelDeliveryOrder(request);
    }
}
