package cn.freemud.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.ConfirmOrderDto;
import cn.freemud.entities.dto.QueryOrdersResponseDto;
import cn.freemud.entities.vo.*;
import com.freemud.application.sdk.api.ordercenter.response.OrderCountResp;
import com.freemud.sdk.api.assortment.order.enums.OrderSdkType;

import java.util.List;
import java.util.Map;

/**
 * 订单服务
 *
 * @author liming.guo
 * @date 2018/05/08
 */
public interface Orderservice {

    /**
     * 创建订单之前校验前面排队的订单数
     */
    BaseResponse checkBeforeCreateOrder(CheckBeforeCreateOrderRequestVo checkBeforeCreateOrderRequestVo);

    /**
     * 创建订单
     */
    BaseResponse createOrderNew(CreateOrderVo createOrderVo);

    BaseResponse scanFaceCreateOrder(CreateOrderVo createOrderVo);

    /**
     * 支付回调
     */
    String paySuccessCallback(PaysuccessNoticeMessage message, ConfirmOrderDto confirmOrderDto, Map<String, QueryOrdersResponseDto.DataBean.OrderBean> orderBeans);

    /**
     * 支付成功后回调通知_新版本
     */
    String newPaySuccessCallback(NewPaysuccessNoticeMessage message);

    /**
     * 退款回掉通知
     */
    String refundNotifyCallback(RefundNotifyCallbackRequestVo message);

    /**
     * 查询订单列表
     */
    BaseResponse queryOrders(QueryOrderVo queryOrderVo);

    /**
     * 通过订单号查询订单详情
     *
     * @param sessionId 用户会话ID
     * @param oid       订单ID
     * @return
     */
    BaseResponse queryOrderById(Integer operation, String sessionId, String oid, String partnerId, String channel);

    /**
     * 支付取消删除订单
     */
    BaseResponse deleteOrder(DeleteOrderVo deleteOrderVo);

    BaseResponse cancelPayOrder(DeleteOrderVo deleteOrderVo);

    /**
     * 支付取消删除订单
     */
    BaseResponse deleteOrderById(DeleteOrderVo deleteOrderVo);

    /**
     * 订单申请退款
     */
    BaseResponse orderRefund(OrderRefundVo orderRefundVo);

    /**
     * 获取订单排队号
     */
    BaseResponse queryOrderQueueIndex(QueryOrderQueueIndexVo queryOrderQueueIndexVo);

    /**
     * 用户评价
     */
    //BaseResponse userOrderEvaluation(AddUserOrderEvaluationRequestVo requestVo);

    /**
     * 用户评价（新接口）
     */
    //BaseResponse userOrderEvaluationNew(AddUserOrderEvaluationNewRequestVo requestVo);

    /**
     * 根据订单查询对应的订单详情
     */
    //BaseResponse getEvaluationByOrderId(GetEvaluationDetailByOrderIdRequestVo requestVo);

    /**
     * 判断订单是否已经评价
     */
    //BaseResponse getEvaluationStatus(GetEvaluationDetailByOrderIdRequestVo requestVo);

    /**
     * 判断订单是否已经评价（新接口）
     */
    //BaseResponse getEvaluationStatusNew(GetEvaluationStatusNewRequestVo requestVo);

    /**
     * 获取退款理由
     */
    BaseResponse getRefundReason(GetRefundReasonVo getRefundReasonVo);

    BaseResponse getNewRefundReason(GetRefundReasonVo getRefundReasonVo);

    /**
     * 创建积分订单
     *
     * @param vo
     * @return
     */
    BaseResponse createIntegralOrder(IntegralOrderVo vo);

    /**
     * @param queryOrderByConditionsRequestVo
     * @return
     * @用户积分订单列表
     */
    BaseResponse queryOrderByConditions(QueryOrderByConditionsRequestVo queryOrderByConditionsRequestVo);

    BaseResponse reminder(ReminderVo reminderVo);

    BaseResponse listFreeRider(FreeRiderPositionVo vo);

    BaseResponse mcCafeQueryOrderById(MaCafeQueryOrderVo queryOrderVo);

    BaseResponse mcCafeQueryOrders(McCafeQueryOrderVo queryOrderVo);

    BaseResponse mcCafePollingPickUpCode(MaCafeQueryOrderVo vo);

    /**
     * 通过订单号查询订单详情
     *
     * @param sessionId 用户会话ID
     * @param oid       订单ID
     * @return
     */
    BaseResponse queryCollageOrderById(Integer operation, String sessionId, String oid, String partnerId, String channel);

    BaseResponse timeOutOrderRefund(TimeOutOrderVo timeOutOrderVo);

    BaseResponse queryOrderRider(OrderRiderRequestVo requestVo);

    /**
     * 统计当日订单数
     *
     * @param queryOrderByConditionsRequestVo
     * @return
     */
    BaseResponse queryTodayOrders(QueryOrderByConditionsRequestVo queryOrderByConditionsRequestVo);

    BaseResponse scoreRecord(QueryOrderVo queryOrderVo);

    /**
     * 【ID1028455】 【订单】非码-腾讯有数数据上报V1.0.0
     * 每天6点前上报昨天数据
     *
     * @param orderCountRequestVo
     * @return
     */
    BaseResponse<List<OrderCountResp>> selectCountOrdersByPartnerIds(OrderCountRequestVo orderCountRequestVo, String trackingNo);
}
