package cn.freemud.fuyou.feign;

import cn.freemud.fuyou.feign.request.CouponAvailableReqVo;
import cn.freemud.fuyou.feign.response.CouponAvailableRespDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * 优惠券
 */
// 测试http://115.159.65.101:8002  线上http://10.51.0.37:8002
//@FeignClient(name = "COUPON",url="${saas.couponclient.feign.url}")
@FeignClient(name = "COUPON-ADAPTER", url = "${saas.couponadapterclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CouponFeignClient {

      /**
       * 获取可用券信息
       *
       * @param couponAvailableReqVo
       * @return
       */
      @PostMapping("/getCouponsAvailable")
      CouponAvailableRespDto getCouponsAvailable(CouponAvailableReqVo couponAvailableReqVo);

}