package cn.freemud.service.adapter;


import cn.freemud.entities.bo.CreateOrderBONew;
import cn.freemud.entities.dto.store.BusinessInfoDto;
import cn.freemud.entities.dto.store.StoreMixResponseDto;
import cn.freemud.entities.vo.CreateOrderBaseVo;
import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.utils.AppLogUtil;
import com.freemud.application.sdk.api.ordercenter.enums.BizTypeEnum;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import com.google.common.collect.Lists;

import java.util.ArrayList;
import java.util.Objects;

/**
 * 订单校验
 */
public class OrderCheckAdapter {

    static ArrayList<OrderCheck> orderCheckList = Lists.newArrayList(new ToStoreCheck(), new TakeOutOrderCheck());

//    /***
//     * 校验预约单门店数据
//     * @param vo
//     * @param storeResponse
//     * @throws ServiceException 抛出异常校验异常数据
//     */
//    public static void check(CreateOrderVo vo, StoreResponse storeResponse) throws ServiceException {
//        // fisherman-ka 预定单的校验 未完成 --> 这里移动了位置
////        if (Objects.nonNull(vo.getBizType())
////                && BizTypeEnum.ADVANCE_ORDER.getBizType().compareTo(vo.getBizType()) == 0) {
////            // 伪代码 判断 门店是否开启了 预定单服务
////            // 开启了预定单服务, 不走下面的检验
////            // 没开启 抛出异常
////        }
//        //非预约单的过滤
//        if (Objects.isNull(vo.getOrderType()) ||
//                (!Objects.equals(vo.getTakeMealFlag(), "1"))) {
//            return;
//        }
//        // 预定单 不校验 下面的预约单
//        if (Objects.nonNull(vo.getBizType())
//                && BizTypeEnum.ADVANCE_ORDER.getBizType().compareTo(vo.getBizType()) == 0) {
//            return;
//        }
//        StoreResponse.Configuration configuration = storeResponse.getBizVO().getStoreConfig();
//        if(Objects.isNull(configuration)){
//            //针对老数据没有配置 预约单默认支持，直接返回不校验
//            AppLogUtil.infoLog("商户:{} shopId:{},没有配置预约单",vo.getPartnerId(),vo.getShopId());
//            return;
//        }
//        for (OrderCheck orderCheck : orderCheckList) {
//            if (orderCheck.support(vo.getOrderType())) {
//                orderCheck.check(vo, storeResponse);
//                return;
//            }
//        }
//    }

    /***
     * 校验预约单门店数据
     * @param vo
     * @param storeResponse
     * @throws ServiceException 抛出异常校验异常数据
     */
    public static void check(CreateOrderBONew createOrderBo) throws ServiceException {
        // fisherman-ka 预定单的校验 未完成 --> 这里移动了位置
//        if (Objects.nonNull(vo.getBizType())
//                && BizTypeEnum.ADVANCE_ORDER.getBizType().compareTo(vo.getBizType()) == 0) {
//            // 伪代码 判断 门店是否开启了 预定单服务
//            // 开启了预定单服务, 不走下面的检验
//            // 没开启 抛出异常
//        }
        CreateOrderVo vo = createOrderBo.getCreateOrderVo();
        StoreMixResponseDto storeMixResponseDto = createOrderBo.getStoreMixResponseDto();
        BusinessInfoDto businessInfo = storeMixResponseDto.getBusinessInfo();

        //非预约单的过滤
        if (Objects.isNull(vo.getOrderType()) ||
                (!Objects.equals(vo.getTakeMealFlag(), "1"))) {
            return;
        }
        // 预定单 不校验 下面的预约单
        if (Objects.nonNull(vo.getBizType())
                && BizTypeEnum.ADVANCE_ORDER.getBizType().compareTo(vo.getBizType()) == 0) {
            return;
        }
        if(Objects.isNull(businessInfo)){
            //针对老数据没有配置 预约单默认支持，直接返回不校验
            AppLogUtil.infoLog("商户:{} shopId:{},没有配置预约单",vo.getPartnerId(),vo.getShopId());
            return;
        }
        for (OrderCheck orderCheck : orderCheckList) {
            if (orderCheck.support(vo.getOrderType())) {
                orderCheck.check(createOrderBo);
                return;
            }
        }
    }



    /***
     * 校验预约单门店数据 优化订单接口冗余方法
     * @param vo
     * @param storeMixResponseDto
     * @throws ServiceException 抛出异常校验异常数据
     */
    public static void check(CreateOrderBaseVo vo, StoreMixResponseDto storeMixResponseDto) throws ServiceException {
        //非预约单的过滤
        if (Objects.isNull(vo.getOrderType()) ||
                (!Objects.equals(vo.getTakeMealFlag(), "1"))) {
            return;
        }
        BusinessInfoDto businessInfo = storeMixResponseDto.getBusinessInfo();
        if(Objects.isNull(businessInfo)){
            //针对老数据没有配置 预约单默认支持，直接返回不校验
            return;
        }
        for (OrderCheck orderCheck : orderCheckList) {
            if (orderCheck.support(vo.getOrderType())) {
                orderCheck.check(null, storeMixResponseDto);
                return;
            }
        }
    }
}
