package cn.freemud.enums;

public enum ActivityImplEnum {

    COUPON_ACTIVITY("COUPON_ACTIVITY","优惠券活动"),
    LIMIT_PRICE("LIMIT_PRICE","限时特价"),
    ;

    private String code;
    private String desc;

    ActivityImplEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ActivityImplEnum getByCode(String code) {
        for (ActivityImplEnum payType : values()) {
            if (payType.getCode().equals(code)) {
                return payType;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
