package cn.freemud.management.service.handle;

import cn.freemud.management.entities.dto.response.pay.OrderRefundResponse;
import cn.freemud.management.entities.dto.response.pay.PayRefundData;
import cn.freemud.management.enums.PaymentRefundStatus;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.freemud.application.sdk.api.base.BaseResponse;
import com.freemud.application.sdk.api.util.ResponseUtils;
import com.freemud.sdk.api.assortment.order.enums.PayRefundStatus;
import org.apache.commons.lang.ObjectUtils;

import java.util.Objects;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2022/6/13 10:56
 * @description :
 */
public class DemoMain {
    public static void main(String[] args) {
        String str = "{\n" +
                "    \"code\": \"100\",\n" +
                "    \"data\": {\n" +
                "        \"refundAmount\": 2,\n" +
                "        \"refundTradeNo\": \"246461447756995675\",\n" +
                "        \"resultCode\": 8200305,\n" +
                "        \"resultMsg\": \"退款测试开关打开：退款成功后失败\",\n" +
                "        \"thirdPartTradeNo\": \"112474208621622061309493318575\",\n" +
                "        \"totalAmount\": 2,\n" +
                "        \"tradeNo\": \"7702399246460840433310808\"\n" +
                "    },\n" +
                "    \"message\": \"success\"\n" +
                "}";
        BaseResponse<PayRefundData> refundNewResponse = JSON.parseObject(str, new TypeReference<BaseResponse<PayRefundData>>() {
        });
        if (Objects.equals(refundNewResponse.getCode(), "100") && refundNewResponse.getData() != null) {
            refundNewResponse.setCode(refundNewResponse.getData().getResultCode().toString());
            refundNewResponse.setMessage(refundNewResponse.getData().getResultMsg());
        }
        if (Objects.equals(refundNewResponse.getCode(), "100")) {
            PayRefundData refundData = refundNewResponse.getData();
            if (null != refundData) {
                OrderRefundResponse refundResponse = new OrderRefundResponse();
                refundResponse.setStatusCode(refundData.getResultCode());
                refundResponse.setMsg(refundData.getResultMsg());
                refundResponse.setRefundAmount(refundData.getRefundAmount());
                refundResponse.setTotalAmount(refundData.getTotalAmount());
                refundResponse.setRefundStatus(getRefundStatus(refundData.getResultCode()));
                refundResponse.setRefundTradeNo(refundData.getRefundTradeNo());
                refundResponse.setTradeNo(refundData.getRefundTradeNo());
                refundResponse.setThirdPartRefundTradeNo(refundData.getThirdPartRefundTradeNo());
                refundResponse.setThirdPartTradeNo(refundData.getThirdPartTradeNo());
                refundResponse.setTotalAmount(refundData.getTotalAmount());
//                return ResponseUtils.success(refundResponse);
            }
        }

        BaseResponse<OrderRefundResponse> orderRefundResponse = ResponseUtils.error(refundNewResponse.getCode(), refundNewResponse.getMessage());

//        Integer refundStatus = PayRefundStatus.SUCCESS;
        Integer refundStatus = 1;
        if (orderRefundResponse == null) {
//            refundStatus = PayRefundStatus.RUNNING;
            refundStatus = 4;
        } else {
            refundStatus = getFinalRefundStatus(Integer.valueOf(orderRefundResponse.getCode()));
        }
        System.out.println(refundStatus);
    }

    private static Integer getFinalRefundStatus(Integer resultCode) {
        switch (resultCode) {
            // 退款中状态码需要单独处理
            case 8200305:
//                return PayRefundStatus.RUNNING;
                return 4;
            // 退款成功
            case 100:
//                return PayRefundStatus.SUCCESS;
                return 1;
            default:
//                return PayRefundStatus.FAIL;
                return 2;
        }
    }

    private static final String SUCCESS = "100";
    public static final Integer SUCCESS_RESPONSE_CODE_INT = 100;
    public static final Integer SUCCESS_RESPONSE_101_CODE_INT = 101;
    public static final Integer REFUND_RESPONSE_CODE = 8200305;

    public static Integer getRefundStatus(Integer resultCode) {
        if (Objects.equals(resultCode, SUCCESS_RESPONSE_CODE_INT)) {
            return PaymentRefundStatus.PAYMENT_REFUND_STATUS_1.getCode();
        } else if (Objects.equals(resultCode, SUCCESS_RESPONSE_101_CODE_INT)) {
            return PaymentRefundStatus.PAYMENT_REFUND_STATUS_1.getCode();
        } else {
            return Objects.equals(resultCode, REFUND_RESPONSE_CODE) ? PaymentRefundStatus.PAYMENT_REFUND_STATUS_4.getCode() : PaymentRefundStatus.PAYMENT_REFUND_STATUS_2.getCode();
        }
    }
}
