package cn.freemud.fuyou.service;

import com.freemud.application.sdk.api.ordercenter.response.BaseResponse;
import cn.freemud.enums.PayChannelEnum;
import cn.freemud.enums.ResponseResult;
import cn.freemud.fuyou.controller.request.DiscountRequest;
import cn.freemud.fuyou.service.processor.EventProcessorRegister;
import com.google.common.collect.ImmutableMap;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Objects;

/**
 * 订单优惠服务
 */
@Component
public class OrderDiscountService {

    private final EventProcessorRegister eventProcessorRegister;

    public OrderDiscountService(EventProcessorRegister eventProcessorRegister) {
        this.eventProcessorRegister = eventProcessorRegister;
    }

    /**
     * @param request
     * @return
     */
    public BaseResponse discount(DiscountRequest request) {
        //支持的优惠方式
        Map<Integer, PayChannelEnum> channelEnumMap = ImmutableMap.of(PayChannelEnum.COUPON.getCode(), PayChannelEnum.COUPON,
                PayChannelEnum.INTEGRAL.getCode(), PayChannelEnum.INTEGRAL
        );

        PayChannelEnum payChannelEnum = channelEnumMap.get(request.getPayChannel());
        if (Objects.isNull(payChannelEnum)) {
            BaseResponse baseResponse = new BaseResponse();
            baseResponse.setCode(ResponseResult.COUPON_TYPE_ERROR.getCode());
            baseResponse.setMessage(ResponseResult.COUPON_TYPE_ERROR.getMessage());
            return baseResponse;
        }
        return eventProcessorRegister.getEventProcessor(payChannelEnum.getCode()).process(request);
    }

}
