package cn.freemud.demo.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.demo.constant.ResponseConstant;
import cn.freemud.demo.entities.*;
import cn.freemud.demo.entities.bo.goods.GetProductBO;
import cn.freemud.demo.entities.bo.goods.GetProductBySkuIdResponseBO;
import cn.freemud.demo.entities.bo.goods.PlatformProductBO;
import cn.freemud.demo.entities.bo.goods.ProductBO;
import cn.freemud.demo.entities.bo.goods.add.BaseAddGoodsBO;
import cn.freemud.demo.manager.coupon.CouponManager;
import cn.freemud.demo.manager.coupon.CouponService;
import cn.freemud.demo.manager.product.ProductManager;
import cn.freemud.demo.manager.customer.CustomerManager;
import cn.freemud.demo.manager.product.ProductService;
import cn.freemud.demo.manager.promotion.PromotionManager;
import cn.freemud.entities.dto.*;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountRequestDto;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.entities.vo.GetProductsVo;
import cn.freemud.entities.vo.ShoppingCartInfoRequestVo;
import cn.freemud.enums.*;
import cn.freemud.interceptor.BizServiceException;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.redis.RedisCache;
import cn.freemud.service.impl.AssortmentSdkService;
import cn.freemud.utils.BeanUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.productcenter.domain.ProductBeanDTO;
import com.freemud.application.sdk.api.productcenter.request.product.valid.ValidateShopProductRequest;
import com.freemud.application.sdk.api.productcenter.response.ProductResponseDTO;
import com.freemud.application.sdk.api.productcenter.response.valid.ValiadShopProductResponse;
import com.freemud.sdk.api.assortment.shoppingcart.constant.CommonsConstant;
import com.freemud.sdk.api.assortment.shoppingcart.domain.ShoppingCartGoodsResponseVo;
import com.freemud.sdk.api.assortment.shoppingcart.enums.BusinessTypeEnum;
import com.freemud.sdk.api.assortment.shoppingcart.service.impl.ShoppingCartBaseServiceImpl;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

public abstract class AbstractAddGoodsService implements AddGoodsService {

    @Autowired
    private CustomerManager customerManager;

    @Autowired
    private ProductManager productManager;

    @Autowired
    private CouponManager couponManager;

    @Autowired
    private AssortmentSdkService assortmentSdkService;

    @Autowired
    private ShoppingCartBaseServiceImpl shoppingCartBaseService;

    @Autowired
    private ShoppingBaseServiceImpl shoppingBaseService;

    @Autowired
    private PromotionManager promotionManager;


    @Autowired
    private RedisCache redisCache;

    private static final String limitCartKey = "ecology:kgd:wxappconfig:open_platform_partner_wxapp_config:appkey_";




    /**
     * 加车的流程
     *
     * @return
     */
    public final AddGoodsShoppingCartBO addGoods(BaseAddGoodsBO addGoodsBO) {
        // 基本参数校验
        this.checkParams(addGoodsBO);

        // 获取购物车和加车商品信息
        CheckBussinessRulesBO checkBussinessRulesBO = this.getShoppingCartInfo(addGoodsBO);

        // 业务校验,例如商品数量库存之类的信息
        AddGoodsToShoppingCartBO addGoodsToShoppingCartBO = this.checkBusinessRules(addGoodsBO, checkBussinessRulesBO);

        // 添加商品到购物车
        DiscountResultBO discountResultBO = this.addGoodsToShoppingCart(addGoodsBO, addGoodsToShoppingCartBO);

        // 去促销计算优惠
        CalCostBO calCostBO = this.getDiscountResult(addGoodsBO, discountResultBO);

        // 计算促销不计算的费用,例如配送费
        DistributeBO distributeBO = this.calCost(addGoodsBO, calCostBO);

        // 添加商品到购物车
        SetMessageBO setMessageBO = this.distribute(addGoodsBO, distributeBO);

        // 提示语设置,例如满减信息
        AddGoodsShoppingCartBO addGoodsShoppingCartBO = this.setMessage(addGoodsBO, setMessageBO);

        return addGoodsShoppingCartBO;
    }

    /**
     * 计算不在促销计算范围里的费用
     * @param addGoodsBO
     * @return
     */
    public final DistributeBO calCost(BaseAddGoodsBO addGoodsBO, CalCostBO calCostBO) {
        DistributeBO commonSetMessageBO = this.calCommCost(addGoodsBO, calCostBO);

        DistributeBO customSetMessageBO = this.calCustomCost(addGoodsBO, calCostBO, commonSetMessageBO);

        return customSetMessageBO;
    }

    public final CalCostBO getDiscountResult(BaseAddGoodsBO addGoodsBO, DiscountResultBO discountResultBO) {
        CalCostBO before = this.getDiscountResultBefore(addGoodsBO, discountResultBO);

        CalCostBO commonSetMessageBO = this.getComDiscountResult(addGoodsBO, discountResultBO, before);

        CalCostBO customSetMessageBO = this.getDiscountResultAfter(addGoodsBO, discountResultBO, commonSetMessageBO);

        return customSetMessageBO;
    }

    public final SetMessageBO distribute(BaseAddGoodsBO addGoodsBO, DistributeBO distributeBO) {
        SetMessageBO commonSetMessageBO = this.commDistribute(addGoodsBO, distributeBO);

        SetMessageBO customSetMessageBO = this.customDistribute(addGoodsBO, distributeBO, commonSetMessageBO);

        return customSetMessageBO;
    }

    /**
     * 设置提示语
     * @param addGoodsBO
     * @return
     */
    public final AddGoodsShoppingCartBO setMessage(BaseAddGoodsBO addGoodsBO, SetMessageBO setMessageBO) {
        AddGoodsShoppingCartBO commonAddGoodsShoppingCartBO = this.setCommMessage(addGoodsBO, setMessageBO);

        AddGoodsShoppingCartBO customAddGoodsShoppingCartBO = this.setCustomMessage(addGoodsBO, setMessageBO, commonAddGoodsShoppingCartBO);

        return customAddGoodsShoppingCartBO;
    }


    /**
     * 请求基本参数校验
     * @return
     */
    public final BaseResponse checkParams(BaseAddGoodsBO baseRequestDTO) {
        BaseResponse commonBaseResponse = this.checkCommParams(baseRequestDTO);
        if (!ResponseConstant.RESPONSE_SUCCESS_STR.equals(commonBaseResponse.getCode())){
            return commonBaseResponse;
        }
        BaseResponse customBaseResponse = this.checkCustomParams(baseRequestDTO);
        if (!ResponseConstant.RESPONSE_SUCCESS_STR.equals(customBaseResponse.getCode())){
            return customBaseResponse;
        }
        return ResponseBuilder.success();
    }

    /**
     * 1. 获取加车的商品信息
     * 2. 获取购物车的商品信息
     *
     * @return
     */
    public final CheckBussinessRulesBO getShoppingCartInfo(BaseAddGoodsBO baseRequestBO) {
        CheckBussinessRulesBO bo = new CheckBussinessRulesBO();
        // 获取用户信息
        String userId = customerManager.getUserId(baseRequestBO.getSessionId(), baseRequestBO.getManagerService().getCustomerService());
        bo.setUserId(userId);

        // 获取商品信息
        GetProductBO getProductBO = convert2ProductBO(baseRequestBO);
        ProductBO productsInfo = productManager.getProductsInfo(getProductBO, baseRequestBO.getManagerService().getProductService());
        bo.setProduct(productsInfo);

        // 获取购物车信息
        // 注意，围餐和点餐redis数据结构不一样
        List<CartGoods> allCartGoodsList = assortmentSdkService.getShoppingCart(baseRequestBO.getPartnerId(), baseRequestBO.getShopId(), userId, baseRequestBO.getSessionId(), null, shoppingCartBaseService);
        if (CollectionUtils.isEmpty(allCartGoodsList)) {
            allCartGoodsList = new ArrayList<>();
        }
        // 转换商品券购物车添加的商品
        if (baseRequestBO.getSpuId().startsWith(CommonsConstant.COUPON_PREFIX)) {
            CartGoods cartGoods = baseRequestBO.getAddGoods();
            cartGoods.setCartGoodsUid(baseRequestBO.getSpuId());
            // 设置商品类型为商品券
            if (CouponTypeEnum.TYPE_4.getCode().equals(getProductBO.getCouponType())) {
                cartGoods.setGoodsType(GoodsTypeEnum.HG_COUPON_GOODS.getGoodsType());
            } else {
                cartGoods.setGoodsType(GoodsTypeEnum.COUPON_GOODS.getGoodsType());
            }
            // 商品券Id
            String spqId = baseRequestBO.getSpuId().substring(CommonsConstant.COUPON_PREFIX.length());
            cartGoods.setSpuId(spqId);
            cartGoods.setSkuId(productsInfo.getSkuId());
            cartGoods.setOriginalPrice(0L);
            cartGoods.setOriginalAmount(0L);
            cartGoods.setAmount(0L);
            cartGoods.setPackPrice(productsInfo.getPackPrice());
            cartGoods.setPic(productsInfo.getPicture());
            cartGoods.setWeight(productsInfo.getWeight());
            cartGoods.setUnit(productsInfo.getUnit());
            boolean stockLimit = false;
            if (productsInfo.getType() == ProductType.NOSPEC.getCode()
                    && productsInfo.getStockLimit() == 1) {
                stockLimit = true;
            } else {
                for (ProductBO.SkuProductBean skuProductBean : productsInfo.getSkuList()) {
                    if (productsInfo.getSkuId().equals(skuProductBean.getSkuId()) && skuProductBean.getStockLimit() == 1) {
                        stockLimit = true;
                        break;
                    }
                }
            }
            cartGoods.setStockLimit(stockLimit);

        }
        List<CartGoods> oldCartGoodsList = BeanUtil.convertBeans(allCartGoodsList, CartGoods::new);
        bo.setCartGoods(oldCartGoodsList);

        return bo;
    }

    private GetCouponDetailBO convert2GetCouponDetailBO(BaseAddGoodsBO baseRequestBO) {
        GetCouponDetailBO getCouponDetailBO = new GetCouponDetailBO();
        getCouponDetailBO.setPartnerId(baseRequestBO.getPartnerId());
        getCouponDetailBO.setCouponCode(baseRequestBO.getCouponCode());
        getCouponDetailBO.setStoreCode(baseRequestBO.getShopId());

        return getCouponDetailBO;
    }

    private GetProductBO convert2ProductBO(BaseAddGoodsBO baseRequestBO) {
        GetProductBO getProductBO = new GetProductBO();
        GetCouponDetailBO getCouponDetail = convert2GetCouponDetailBO(baseRequestBO);
        getProductBO.setStoreId(baseRequestBO.getShopId());
        getProductBO.setMenuType(baseRequestBO.getMenuType());
        getProductBO.setPartnerId(baseRequestBO.getPartnerId());
        if (baseRequestBO.getSpuId().startsWith(CommonsConstant.COUPON_PREFIX)) {
            // 如果是商品券,获取商品券信息
            CouponDetailBO couponDetail = couponManager.getCouponDetail(getCouponDetail, baseRequestBO.getManagerService().getCouponService());

            if (couponDetail == null || !couponDetail.getResult().equals(ResponseCodeConstant.RESPONSE_SUCCESS_1) || CollectionUtils.isEmpty(couponDetail.getDetails())) {
                return null;
            }
            if (CollectionUtils.isEmpty(couponDetail.getDetails())) {
                return null;
            }
            Integer couponType = 0;
            boolean productValid = false;
            for (CouponDetailBO.Details detail : couponDetail.getDetails()) {
                if (productValid) break;
                if (!CouponStatus.STATUS_0.getCode().equals(detail.getStatus())) continue;
                for (CouponDetailBO.ActiveProduct activeProduct : detail.getActiveProduct()) {
                    if (baseRequestBO.getSkuId().equals(activeProduct.getProductIdPartner())) {
                        productValid = true;
                        couponType = detail.getType();
                        break;
                    }
                }
            }
            //检查商品是否有效
            if (!productValid) {
                return null;
            }
            // 判断该券是否在这个门店下(一个券可以在多个门店下使用)
            List<String> couPonstoreIds = Lists.newArrayList();
            for (CouponDetailBO.Details detail : couponDetail.getDetails()) {
                if (!CouponStatus.STATUS_0.getCode().equals(detail.getStatus())) continue;
                for (CouponDetailBO.ActiveRestrictionVOS activeRestrictionVO : detail.getActiveRestrictionVOS()) {
                    couPonstoreIds.add(activeRestrictionVO.getStoreIdPartner());
                }
            }
            if (CollectionUtils.isNotEmpty(couPonstoreIds) && !couPonstoreIds.contains(baseRequestBO.getShopId())) {
                return null;
            }

            //券返回的商品id
            List<String> skuIds = Lists.newArrayList();
            String skuId = baseRequestBO.getSpuId();
            skuIds.add(skuId);
            // 通过skuid查询spuid
            GetProductBySkuIdBO getProductBySkuIdBO = convert2GetProductBySkuIdBO(baseRequestBO);
            Map<String, GetProductBySkuIdResponseBO> productsInfoBySkuIds = productManager.getProductsInfoBySkuIds(getProductBySkuIdBO, baseRequestBO.getManagerService().getProductService());
            GetProductBySkuIdResponseBO productsVo = productsInfoBySkuIds.get(skuId);
            if (null == productsVo || !Objects.equals(productsVo.getStatus(), StoreItemStatus.PUT_ON_SALE.getCode())) {
                return null;
            }
            // TODO 后面做校验商品可用时间
            /*
            ValidateShopProductRequest request = getValidateShopProductRequest(productsVo, requestDto);
            ProductResponseDTO<ValiadShopProductResponse> valiadProductResponse = storeItemClient.validateShopProduct(request);
            if (null == valiadProductResponse || !Objects.equals(com.freemud.application.sdk.api.productcenter.constant.ResponseConstant.SUCCESS_RESPONSE_CODE, valiadProductResponse.getErrcode())
                    || valiadProductResponse.getData() == null || CollectionUtils.isEmpty(valiadProductResponse.getData().getSuccessList())) {
                return null;
            }
             */
            getProductBO.setSpuid(productsVo.getSpuId());
            getProductBO.setSkuid(productsVo.getSkuId());
            getProductBO.setCouponType(couponType);
        } else {
            getProductBO.setSkuid(baseRequestBO.getSkuId());
            getProductBO.setSpuid(baseRequestBO.getSpuId());
        }

        return getProductBO;
    }

    private GetProductBySkuIdBO convert2GetProductBySkuIdBO(BaseAddGoodsBO baseRequestBO) {
        GetProductBySkuIdBO getProductBySkuIdBO = new GetProductBySkuIdBO();
        getProductBySkuIdBO.setMenuType(baseRequestBO.getMenuType());
        getProductBySkuIdBO.setPartnerId(baseRequestBO.getPartnerId());
        List<String> skuids = new ArrayList<>();
        skuids.add(baseRequestBO.getSkuId());
        getProductBySkuIdBO.setSkuids(skuids);
        getProductBySkuIdBO.setStoreId(baseRequestBO.getShopId());
        return getProductBySkuIdBO;
    }

    /**
     * 具体业务逻辑校验, 例如商品数量,库存等校验
     *
     * @return
     */
    public final AddGoodsToShoppingCartBO checkBusinessRules(BaseAddGoodsBO baseRequestDTO, CheckBussinessRulesBO checkBussinessRulesBO) {
        AddGoodsToShoppingCartBO commAddGoodsToShoppingCartBO = this.checkCommBusinessRules(baseRequestDTO, checkBussinessRulesBO);
        AddGoodsToShoppingCartBO customAddGoodsToShoppingCartBO = this.checkCustomBusinessRules(baseRequestDTO, checkBussinessRulesBO, commAddGoodsToShoppingCartBO);
        return customAddGoodsToShoppingCartBO;
    }


    /**
     * 添加商品到购物车,并重新设置购物车
     *
     * @return
     */
    public final DiscountResultBO addGoodsToShoppingCart(BaseAddGoodsBO baseRequestDTO, AddGoodsToShoppingCartBO addGoodsToShoppingCartBO) {

        DiscountResultBO commCalCostBO = this.commAddGoodsToShoppingCart(baseRequestDTO, addGoodsToShoppingCartBO);

        DiscountResultBO customCalCostBO = this.customAddGoodsToShoppingCart(baseRequestDTO, addGoodsToShoppingCartBO, commCalCostBO);

        this.updateShoppingCartCache(customCalCostBO);

        return commCalCostBO;
    }


    private BaseResponse checkCommParams(BaseAddGoodsBO baseRequestDTO) {

        if (StringUtils.isEmpty(baseRequestDTO.getShopId())){
            throw new ServiceException(ResponseResult.SHOPPING_CART_SHOP_ID_NOT_EMPTY);
        }

        return ResponseBuilder.success();
    }

    private AddGoodsToShoppingCartBO checkCommBusinessRules(BaseAddGoodsBO baseRequestDTO, CheckBussinessRulesBO checkBussinessRulesBO) {
        AddGoodsToShoppingCartBO bo = new AddGoodsToShoppingCartBO();
        // 校验商品券是否在可用时间

        //购物车添加数量限制
        CartGoods addGoods = baseRequestDTO.getAddGoods();
        this.limitGoodsQty(checkBussinessRulesBO.getCartGoods(), addGoods, baseRequestDTO.getAppId());
        // 校验数量, 库存
        this.checkStocks(baseRequestDTO, checkBussinessRulesBO);
        // 检查校验购物车商品(是否合法,上下架,点餐方式,是否在当前菜单中...),并移除非法商品
        ShoppingCartContext cartContext = convert2ShopingCartContext(baseRequestDTO);

        CheckCartRequest checkCartRequest = shoppingBaseService.checkShoppingCart(checkBussinessRulesBO.getCartGoods(), addGoods, cartContext);
        checkBussinessRulesBO.setChanged(checkCartRequest.getChanged());
        checkBussinessRulesBO.setToastMsg(checkCartRequest.getToastMsg());

        bo.setCartGoods(checkBussinessRulesBO.getCartGoods());
        bo.setChanged(checkCartRequest.getChanged());
        bo.setProduct(checkBussinessRulesBO.getProduct());
        bo.setShoppingCartContext(cartContext);
        bo.setToastMsg(checkCartRequest.getToastMsg());


        return bo;
    }

    private DiscountResultBO commAddGoodsToShoppingCart(BaseAddGoodsBO baseRequestDTO, AddGoodsToShoppingCartBO addGoodsToShoppingCartBO) {
        DiscountResultBO calCostBO = new DiscountResultBO();
        List<CartGoods> cartGoods = shoppingBaseService.updateAndGetShoppingCart(addGoodsToShoppingCartBO.getCartGoods(), baseRequestDTO.getAddGoods(), addGoodsToShoppingCartBO.getShoppingCartContext());

        calCostBO.setCartGoods(cartGoods);
        calCostBO.setChanged(addGoodsToShoppingCartBO.getChanged());
        calCostBO.setShoppingCartContext(addGoodsToShoppingCartBO.getShoppingCartContext());
        calCostBO.setToastMsg(addGoodsToShoppingCartBO.getToastMsg());

        return calCostBO;
    }

    public final void updateShoppingCartCache(DiscountResultBO calCostBO) {
        return ;
    }

    private DistributeBO calCommCost(BaseAddGoodsBO baseRequestDTO, CalCostBO calCostBO) {
        return null;
    }

    private AddGoodsShoppingCartBO setCommMessage(BaseAddGoodsBO baseRequestDTO, SetMessageBO setMessageBO) {
        return null;
    }

    private CalCostBO getComDiscountResult(BaseAddGoodsBO baseRequestDTO, DiscountResultBO discountResultBO, CalCostBO before) {

        CalculationDiscountBO calculationDiscountBO = promotionManager.calculationDiscount(before.getGetCalculationDiscountBO(), baseRequestDTO.getManagerService().getPromotionService());
        before.setCalculationDiscountBO(calculationDiscountBO);

        return before;
    }

    private SetMessageBO commDistribute(BaseAddGoodsBO baseRequestDTO, DistributeBO calCostBO) {
        return null;
    }

    private void addCalculationDiscountGoods(List<ActivityCalculationDiscountRequestDto.CalculationDiscountGoods> calculationDiscountGoodsList,
                                                     String goodsCode,String goodsId, Integer goodsQuantity, Long originalPrice, Integer memberDiscount,CartGoods cartGoods) {
        ActivityCalculationDiscountRequestDto.CalculationDiscountGoods calculationDiscountGoods = new ActivityCalculationDiscountRequestDto.CalculationDiscountGoods();
        calculationDiscountGoods.setGoodsCode(goodsCode);
        calculationDiscountGoods.setGoodsId(goodsId);
        calculationDiscountGoods.setGoodsQuantity(goodsQuantity);
        calculationDiscountGoods.setOriginalPrice(originalPrice);
        calculationDiscountGoods.setMemberDiscount(memberDiscount);
        //新增咖啡月卡券券号
        calculationDiscountGoods.setCouponCode(cartGoods.getCouponCode());
        calculationDiscountGoods.setCartGoodsUid(cartGoods.getCartGoodsUid());

        ArrayList<ActivityCalculationDiscountRequestDto.CalculationDiscountGoods.Material> materials = new ArrayList<>();
        //可选搭配
        if (cartGoods != null && CollectionUtils.isNotEmpty(cartGoods.getProductGroupList())) {
            for (CartGoods.ComboxGoods materialGoods : cartGoods.getProductGroupList()) {
                if("0".equals(materialGoods.getGoodsId())){
                    continue;
                }
                ActivityCalculationDiscountRequestDto.CalculationDiscountGoods.Material material = new ActivityCalculationDiscountRequestDto.CalculationDiscountGoods.Material();
                material.setType(2);
                material.setGoodsId(materialGoods.getGoodsId());
                material.setGoodsQuantity(materialGoods.getQty());
                material.setOriginalPrice(null != materialGoods.getFinalPrice() ?
                        materialGoods.getFinalPrice() : 0);
                materials.add(material);
            }
        }

        //固定商品
        if (cartGoods != null && CollectionUtils.isNotEmpty(cartGoods.getProductComboList())) {
            for (CartGoods.ComboxGoods materialGoods : cartGoods.getProductComboList()) {
                //加料
                if (CollectionUtils.isNotEmpty(materialGoods.getProductMaterialList())) {
                    for (CartGoods.MaterialGoods materialGoods2 : materialGoods.getProductMaterialList()) {
                        if (StringUtils.isEmpty(materialGoods2.getSpuId())) {
                            continue;
                        }
                        ActivityCalculationDiscountRequestDto.CalculationDiscountGoods.Material material = new ActivityCalculationDiscountRequestDto.CalculationDiscountGoods.Material();
                        material.setType(1);
                        material.setGoodsId(materialGoods2.getSpuId());
                        material.setGoodsQuantity(1);
                        material.setOriginalPrice(null != materialGoods2.getFinalPrice() ?
                                materialGoods2.getFinalPrice() : 0);
                        materials.add(material);
                    }
                }
            }
        }

        //加料
        if (null != cartGoods && CollectionUtils.isNotEmpty(cartGoods.getProductMaterialList())) {
            for (CartGoods.MaterialGoods materialGoods : cartGoods.getProductMaterialList()) {
                ActivityCalculationDiscountRequestDto.CalculationDiscountGoods.Material material = new ActivityCalculationDiscountRequestDto.CalculationDiscountGoods.Material();
                material.setType(1);
                material.setGoodsId(materialGoods.getSpuId());
                material.setGoodsQuantity(1);
                material.setOriginalPrice(null != materialGoods.getOriginalPrice() ?
                        materialGoods.getOriginalPrice() : 0);
                material.setNowPrice(null != materialGoods.getFinalPrice() ? materialGoods.getFinalPrice().intValue():0);
                materials.add(material);
            }
        }
        calculationDiscountGoods.setSmallMaterial(materials);
        calculationDiscountGoodsList.add(calculationDiscountGoods);

    }

    private ShoppingCartContext convert2ShopingCartContext(BaseAddGoodsBO baseRequestDTO){
        ShoppingCartContext cartContext = new ShoppingCartContext();
        cartContext.setMenuType(baseRequestDTO.getMenuType());
        cartContext.setOrderType(baseRequestDTO.getOrderType());
        cartContext.setPartnerId(baseRequestDTO.getPartnerId());
        cartContext.setShopId(baseRequestDTO.getShopId());
        cartContext.setUserId(baseRequestDTO.getUserId());
        cartContext.setSessionId(baseRequestDTO.getSessionId());
        cartContext.setTableNumber(baseRequestDTO.getTableNumber());
        return cartContext;
    }

    /**
     * 查询生态配置限制加购开关与限制数量
     */
    private Integer limitGoodsQty(List<CartGoods> oldCartGoodsList, CartGoods addGoods,String appid){
        Integer qty = 0;
        if(CollectionUtils.isNotEmpty(oldCartGoodsList)){
            for (CartGoods goods : oldCartGoodsList) {
                qty += goods.getQty();
            }
        }
        qty += addGoods.getQty();
        String redisKey = limitCartKey + appid;

        Object value = redisCache.hashGet(redisKey, "2");
        if (value == null) {
            return qty;
        } else {
            boolean bool = value.getClass().getName().equals("java.lang.String");
            if(bool){
                return qty;
            }
            JSONArray jsonArray = (JSONArray)value;
            int cartLimitFlag = 0;
            int cartLimitCount = 0;
            for (Object object : jsonArray){
                JSONObject jsonObject = (JSONObject)object;
                HashMap hashMap = JSONObject.parseObject(jsonObject.toJSONString(),HashMap.class);
                if("cartLimitFlag".equals(hashMap.get("appKey"))){
                    if (StringUtils.isBlank((String)hashMap.get("appValue"))) {
                        return qty;
                    }
                    cartLimitFlag = Integer.parseInt((String)hashMap.get("appValue"));
                }
                if("cartLimitCount".equals(hashMap.get("appKey"))){
                    if (StringUtils.isBlank((String)hashMap.get("appValue"))) {
                        return qty;
                    }
                    cartLimitCount = Integer.parseInt((String)hashMap.get("appValue"));
                }
            }
            if(cartLimitFlag == 1 && cartLimitCount != 0 && qty > cartLimitCount){
                throw new ServiceException(ResponseResult.SHOPPING_CART_LIMIT_ADD);
            }
        }
        return qty;
    }

    private void checkStocks(BaseAddGoodsBO baseRequestDTO, CheckBussinessRulesBO checkBussinessRulesBO){
        GetProductStockRequestDto requestDto = new GetProductStockRequestDto();
        requestDto.setChannel(BusinessTypeEnum.getByType(baseRequestDTO.getMenuType()).getCode());
        requestDto.setPartnerId(baseRequestDTO.getPartnerId());
        requestDto.setStoreId(baseRequestDTO.getShopId());
        List<Long> productIds = new ArrayList<>();
        productIds.add(Long.parseLong(checkBussinessRulesBO.getProduct().getSkuId()));
        requestDto.setProductIds(productIds);


        ProductBO product = checkBussinessRulesBO.getProduct();
        ProductStockBO availableStocks = null;
        GetProductStock getProductStock = new GetProductStock();
        if (product.getType() == ProductType.NOSPEC.getCode()
                && product.getStockLimit() == 1) {
            List<ProductStockBO> productStock = productManager.getProductStock(getProductStock, baseRequestDTO.getManagerService().getProductService());
            if (CollectionUtils.isNotEmpty(productStock)){
                availableStocks = productStock.get(0);
            }

        } else {
            for (ProductBO.SkuProductBean skuProductBean : product.getSkuList()) {
                if (baseRequestDTO.getSkuId().equals(skuProductBean.getSkuId()) && skuProductBean.getStockLimit() == 1) {
                    List<ProductStockBO> productStock = productManager.getProductStock(getProductStock, baseRequestDTO.getManagerService().getProductService());
                    if (CollectionUtils.isNotEmpty(productStock)){
                        availableStocks = productStock.get(0);
                    }
                    break;
                }
            }
        }
        if (availableStocks != null ) {
            throw new ServiceException(ResponseResult.SHOPPING_CART_STOCK_NOT_HAVE);
        }

        List<CartGoods> oldCartGoodsList = checkBussinessRulesBO.getCartGoods();
        CartGoods cartGoods = baseRequestDTO.getAddGoods();
        Integer qty = 0;
        if (CollectionUtils.isEmpty(oldCartGoodsList)) {
            qty = cartGoods.getQty();
        } else {
            qty = cartGoods.getQty();
            for (CartGoods goods : oldCartGoodsList) {
                if (goods.getSkuId().equals(cartGoods.getSkuId()) && goods.getSpuId().equals(cartGoods.getSpuId())) {
                    qty += goods.getQty();
                }
            }
        }
        if (availableStocks != null  &&
                (availableStocks.getQty() == null
                        || availableStocks.getQty() < qty)) {
            Integer stock = 0;
            if ((stock = availableStocks.getQty()) > 0) {
                throw new BizServiceException(ResponseResult.SHOPPING_CART_STOCK_NOT_HAVE, "仅剩" + stock + "件库存了");
            }
            throw new ServiceException(ResponseResult.SHOPPING_CART_STOCK_NOT_HAVE);
        }
    }

}
