package cn.freemud.demo.manager.promotion;

import cn.freemud.demo.adapter.manager.PromotionBO2DTOAdapter;
import cn.freemud.demo.adapter.manager.PromotionDTO2BOAdapter;
import cn.freemud.demo.entities.CalculationDiscountBO;
import cn.freemud.demo.entities.GetCalculationDiscountBO;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountRequestDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountResponseDto;
import cn.freemud.service.thirdparty.CalculationClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("KgdPromotionService")
public class KgdPromotionServiceImpl implements PromotionService{

    @Autowired
    private CalculationClient calculationClient;

    @Autowired
    private PromotionBO2DTOAdapter promotionBO2DTOAdapter;

    @Autowired
    private PromotionDTO2BOAdapter promotionDTO2BOAdapter;

    @Override
    public CalculationDiscountBO calculationDiscount(GetCalculationDiscountBO getCalculationDiscountBO) {

        CalculationSharingDiscountRequestDto shareDiscountRequestDto = promotionBO2DTOAdapter.convert2CalculationSharingDiscountRequestDto(getCalculationDiscountBO);

        CalculationSharingDiscountResponseDto calculationSharingDiscountResponseDto = calculationClient.calculationSharingDiscount(shareDiscountRequestDto);

        CalculationDiscountBO calculationDiscountBO = promotionDTO2BOAdapter.convert2CalculationDiscountBO(calculationSharingDiscountResponseDto);

        return calculationDiscountBO;
    }
}
