package cn.freemud.demo.manager.product;

import cn.freemud.demo.adapter.manager.ProductBO2DTOAdapter;
import cn.freemud.demo.adapter.manager.ProductDTO2BOAdapter;
import cn.freemud.demo.entities.GetProductBySkuIdBO;
import cn.freemud.demo.entities.GetProductStock;
import cn.freemud.demo.entities.ProductStockBO;
import cn.freemud.demo.entities.bo.goods.GetProductBO;
import cn.freemud.demo.entities.bo.goods.GetProductBySkuIdResponseBO;
import cn.freemud.demo.entities.bo.goods.PlatformProductBO;
import cn.freemud.demo.entities.bo.goods.ProductBO;
import cn.freemud.entities.dto.GetProductStockRequestDto;
import cn.freemud.entities.dto.GetProductStockResponseDto;
import cn.freemud.entities.vo.GetProductsVo;
import cn.freemud.service.ItemService;
import cn.freemud.service.impl.AssortmentSdkService;
import cn.freemud.service.thirdparty.StockClient;
import com.freemud.application.sdk.api.productcenter.domain.ProductBeanDTO;
import com.freemud.sdk.api.assortment.shoppingcart.service.impl.ShoppingCartBaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Service("KgdProductService")
public class KgdProductServiceImpl implements ProductService {


    @Autowired
    private AssortmentSdkService assortmentSdkService;

    @Autowired
    private ProductDTO2BOAdapter productDTO2BOAdapter;

    @Autowired
    private ProductBO2DTOAdapter productBO2DTOAdapter;


    @Autowired
    private ItemService itemService;

    @Autowired
    private ShoppingCartBaseServiceImpl shoppingCartBaseService;

    @Autowired
    private StockClient stockClient;

    @Override
    public ProductBO getProductInfo(GetProductBO getProductBO) {
        // 获取添加商品的详细信息
        List< ProductBeanDTO> productBeanListSpuClass = assortmentSdkService.getProductsInfoSdk(getProductBO.getPartnerId(),
                        getProductBO.getStoreId(), Collections.singletonList(getProductBO.getSkuid()), getProductBO.getMenuType(), shoppingCartBaseService);
        ProductBeanDTO productBeanDTO = productBeanListSpuClass.get(0);

        ProductBO platformProductBO = productDTO2BOAdapter.convert2ProductBO(productBeanDTO);

        return platformProductBO;
    }

    @Override
    public Map<String, GetProductBySkuIdResponseBO> getProductInfoBySkuIds(GetProductBySkuIdBO getProductBySkuIdBO) {

        Map<String, GetProductBySkuIdResponseBO> products = itemService.getProductsBySkuId(getProductBySkuIdBO.getSkuids(), getProductBySkuIdBO.getPartnerId(),
                getProductBySkuIdBO.getStoreId(), getProductBySkuIdBO.getMenuType());


        return products;
    }

    @Override
    public List<ProductStockBO> getProductStock(GetProductStock getProductStock) {

        GetProductStockRequestDto getProductStockRequestDto = productBO2DTOAdapter.convert2GetProductStockDto(getProductStock);

        GetProductStockResponseDto availableStocks = stockClient.getAvailableStocks(getProductStockRequestDto);
        List<GetProductStockResponseDto.DataBean> result = availableStocks.getResult();

        List<ProductStockBO> list = new ArrayList<>();
        for (GetProductStockResponseDto.DataBean dataBean : result){
            ProductStockBO productStockBO = productDTO2BOAdapter.convert2ProductStockBO(dataBean);
            list.add(productStockBO);
        }
        return list;

    }
}
