package cn.freemud.demo.manager.customer;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.demo.adapter.manager.CustomerDTO2BOAdapter;
import cn.freemud.demo.entities.QueryReceiveAddressByIdBO;
import cn.freemud.demo.entities.ReceiveAddressBO;
import cn.freemud.entities.dto.user.GetSessionUserInfoDto;
import cn.freemud.entities.vo.CustomerInfoVo;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.service.thirdparty.CustomerApplicationClient;
import com.freemud.application.sdk.api.membercenter.request.QueryReceiveAddressRequest;
import com.freemud.application.sdk.api.membercenter.response.QueryReceiveAddressResponse;
import com.freemud.application.sdk.api.membercenter.service.MemberCenterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("KgdCustomerService")
public class KgdCustomerServceImpl implements CustomerService {

    @Autowired
    private CustomerApplicationClient customerApplicationClient;


    @Autowired
    private MemberCenterService memberCenterService;
    @Autowired
    private CustomerDTO2BOAdapter customerDTO2BOAdapter;


    @Override
    public String getUserId(String sessionId) {
        GetSessionUserInfoDto getSessionUserInfoDto = new GetSessionUserInfoDto();
        getSessionUserInfoDto.setIsGetPaid(true);
        getSessionUserInfoDto.setSessionId(sessionId);
        BaseResponse<CustomerInfoVo> sessionUserInfo = customerApplicationClient.getSessionUserInfo(getSessionUserInfoDto);
        if (!ResponseResult.SUCCESS.getCode().equals(sessionUserInfo.getCode()) || sessionUserInfo.getResult() == null) {
            throw new ServiceException(ResponseResult.NOT_LOGIN);
        }
        return sessionUserInfo.getResult().getSessionId();
    }

    @Override
    public ReceiveAddressBO queryReceiveAddressById(QueryReceiveAddressByIdBO queryReceiveAddressByIdBO) {
        QueryReceiveAddressRequest request = new QueryReceiveAddressRequest(queryReceiveAddressByIdBO.getAddressId(), queryReceiveAddressByIdBO.getPartnerId());
        com.freemud.application.sdk.api.base.BaseResponse<QueryReceiveAddressResponse> queryReceiveAddressResponse = memberCenterService.queryReceiveAddressById(request, "");
        if (!ResponseResult.SUCCESS.getCode().equals(queryReceiveAddressResponse.getCode()) || queryReceiveAddressResponse.getData() == null) {
            throw new ServiceException(ResponseResult.USER_GETRECEIVEADDRESS_ERROR);
        }
        ReceiveAddressBO receiveAddressBO = customerDTO2BOAdapter.convert2StoreInfoBO(queryReceiveAddressResponse.getData());
        return receiveAddressBO;


    }
}
