package cn.freemud.demo.adapter.service;

import cn.freemud.demo.entities.ManagerServiceBO;
import cn.freemud.demo.entities.bo.goods.*;
import cn.freemud.demo.entities.bo.goods.add.*;
import cn.freemud.demo.entities.dto.goods.add.*;
import cn.freemud.demo.enums.BizTypeEnum;
import cn.freemud.demo.manager.customer.CustomerService;
import cn.freemud.demo.manager.product.ProductService;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.entities.vo.ComboxGoodsRequestVo;
import cn.freemud.entities.vo.MaterialRequestVo;
import cn.freemud.enums.GoodsTypeEnum;
import com.freemud.sdk.api.assortment.shoppingcart.constant.CommonsConstant;
import ma.glasnost.orika.MapperFacade;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Component
public class AddGoodsBOAdapter {

    @Autowired
    @Qualifier("KgdCustomerService")
    private CustomerService kgdCustomerServIce;

    @Autowired
    @Qualifier("KgdProductService")
    private ProductService kgdProductService;

    @Resource
    private MapperFacade mapperFacade;


    public BaseAddGoodsBO convert2AddGoodsBO(String bizType, AddGoodsRequestDTO baseRequestDTO) {
        BaseAddGoodsBO baseAddGoodsBO;
        if (BizTypeEnum.MCOFFEE.getCode().equals(bizType)) {
            baseAddGoodsBO = createMCoffeeBO(baseRequestDTO);
        } else {
            baseAddGoodsBO = createPlatformBO(baseRequestDTO);
        }
        return baseAddGoodsBO;
    }

    private PlatformAddGoodsBO createPlatformBO(AddGoodsRequestDTO baseRequestDTO) {


        PlatformAddGoodsBO platformAddGoodsBO = mapperFacade.map(baseRequestDTO, PlatformAddGoodsBO.class);
        CartGoods platformProductBO = convert2PlatformProductBO(baseRequestDTO);
        platformAddGoodsBO.setAddGoods(platformProductBO);

        ManagerServiceBO managerService = ManagerServiceBO.builder()
                .customerService(kgdCustomerServIce)
                .productService(kgdProductService)
                .build();
        platformAddGoodsBO.setManagerService(managerService);

        return platformAddGoodsBO;
    }



    private MCoffeeAddGoodsBO createMCoffeeBO(AddGoodsRequestDTO baseRequestDTO) {
        MCoffeeAddGoodsBO mCoffeeAddGoodsBO = mapperFacade.map(baseRequestDTO, MCoffeeAddGoodsBO.class);
        McoffeeProductBO mcoffeeProductBO = convert2MCoffeeProductBO(mCoffeeAddGoodsBO);
        mCoffeeAddGoodsBO.setAddGoods(mcoffeeProductBO);

        ManagerServiceBO managerService = ManagerServiceBO.builder()
                .customerService(kgdCustomerServIce)
                .productService(kgdProductService)
                .build();
        mCoffeeAddGoodsBO.setManagerService(managerService);

        return mCoffeeAddGoodsBO;
    }


    private CartGoods convert2PlatformProductBO(AddGoodsRequestDTO baseRequestDTO) {
        CartGoods platformProductBO = mapperFacade.map(baseRequestDTO, CartGoods.class);

        String spuId = baseRequestDTO.getSpuId();
        String skuId = baseRequestDTO.getSkuId();
        String goodsId = StringUtils.isEmpty(skuId) ? spuId : skuId;
        Integer qty = baseRequestDTO.getQty() == null ? 1 : baseRequestDTO.getQty();
        platformProductBO.setGoodsId(goodsId);
        platformProductBO.setQty(qty);
        Integer goodsType = StringUtils.isEmpty(skuId)||ObjectUtils.equals(spuId,skuId) ? GoodsTypeEnum.SPU_GOODS.getGoodsType() : GoodsTypeEnum.SKU_GOODS.getGoodsType();
        if (spuId.startsWith(CommonsConstant.COUPON_PREFIX)) {
            goodsType = GoodsTypeEnum.COUPON_GOODS.getGoodsType();
        } else if (CollectionUtils.isNotEmpty(baseRequestDTO.getProductComboList()) || CollectionUtils.isNotEmpty(baseRequestDTO.getProductGroupList())) {
            goodsType = GoodsTypeEnum.SET_MEAL_GOODS.getGoodsType();
        }
        platformProductBO.setGoodsType(goodsType);
        List<CartGoods.ComboxGoods> productComboList = new ArrayList<>();
        List<CartGoods.ComboxGoods> productGroupList = new ArrayList<>();
        List<CartGoods.MaterialGoods> materialGoodsList = new ArrayList<>();
        //套餐
        if (CollectionUtils.isNotEmpty(baseRequestDTO.getProductComboList())) {
            for (ComboxGoodsRequestVo vo : baseRequestDTO.getProductComboList()) {
                CartGoods.ComboxGoods productCombox = new CartGoods.ComboxGoods();
                productCombox.setGoodsId(vo.getSkuId());
                productCombox.setSkuId(vo.getSkuId());
                productCombox.setQty(vo.getQty());
                productCombox.setExtra(vo.getExtra());
                productComboList.add(productCombox);
            }
        }
        //固定商品组
        if (CollectionUtils.isNotEmpty(baseRequestDTO.getProductGroupList())) {
            for (ComboxGoodsRequestVo vo : baseRequestDTO.getProductGroupList()) {
                CartGoods.ComboxGoods productCombox = new CartGoods.ComboxGoods();
                productCombox.setGoodsId(vo.getSkuId());
                productCombox.setSkuId(vo.getSkuId());
                productCombox.setQty(vo.getQty());
                productCombox.setExtra(vo.getExtra());
                productCombox.setProductGroupId(StringUtils.isBlank(vo.getProductGroupId()) ? null : Long.parseLong(vo.getProductGroupId()));
                productGroupList.add(productCombox);
            }
        }
        //加料商品集
        if (CollectionUtils.isNotEmpty(baseRequestDTO.getProductMaterialList())) {
            for (MaterialRequestVo materialRequestVo : baseRequestDTO.getProductMaterialList()) {
                CartGoods.MaterialGoods materialGoods = new CartGoods.MaterialGoods();
                materialGoods.setSpuId(materialRequestVo.getSpuId());
                materialGoodsList.add(materialGoods);
            }
        }
        platformProductBO.setProductComboList(productComboList);
        platformProductBO.setProductGroupList(productGroupList);
        platformProductBO.setProductMaterialList(materialGoodsList);

        return platformProductBO;

    }

    private McoffeeProductBO convert2MCoffeeProductBO(MCoffeeAddGoodsBO baseRequestDTO) {

        McoffeeProductBO mcoffeeProductBO = mapperFacade.map(baseRequestDTO, McoffeeProductBO.class);

        String spuId = baseRequestDTO.getSpuId();
        String skuId = baseRequestDTO.getSkuId();
        String goodsId = StringUtils.isEmpty(skuId) ? spuId : skuId;
        Integer qty = baseRequestDTO.getQty() == null ? 1 : baseRequestDTO.getQty();
        mcoffeeProductBO.setGoodsId(goodsId);
        mcoffeeProductBO.setSpuId(spuId);
        mcoffeeProductBO.setSkuId(skuId);
        mcoffeeProductBO.setQty(qty);

        Integer goodsType = StringUtils.isEmpty(skuId) || ObjectUtils.equals(spuId, skuId) ? GoodsTypeEnum.SPU_GOODS.getGoodsType() : GoodsTypeEnum.SKU_GOODS.getGoodsType();
        if (CollectionUtils.isNotEmpty(baseRequestDTO.getProductComboList()) || CollectionUtils.isNotEmpty(baseRequestDTO.getProductGroupList())) {
            goodsType = GoodsTypeEnum.SET_MEAL_GOODS.getGoodsType();
        } else if (CommonsConstant.COUPON_TYPE == baseRequestDTO.getCouponType()){
            goodsType = GoodsTypeEnum.ALL_COUPON_GOODS.getGoodsType();
        }
        if (baseRequestDTO.getOperationType() != null && baseRequestDTO.getOperationType() == 2) {
            goodsType = GoodsTypeEnum.REDUCE_PRICE_GOODS.getGoodsType();
        }
        mcoffeeProductBO.setGoodsType(goodsType);
        List<CartGoodsExtra> cartGoodsExtras = mapperFacade.mapAsList(baseRequestDTO.getExtra(), CartGoodsExtra.class);
        mcoffeeProductBO.setExtra(cartGoodsExtras);
        List<CartGoodsExtra> sprcialExtras = mapperFacade.mapAsList(baseRequestDTO.getExtra(), CartGoodsExtra.class);

        mcoffeeProductBO.setSpecialExtra(sprcialExtras);
        List<McoffeeComboxGoodsBO> productComboList = new ArrayList<>();
        List<McoffeeComboxGoodsBO> productGroupList = new ArrayList<>();

        if (CollectionUtils.isNotEmpty(baseRequestDTO.getProductComboList())) {
            for (ComboxGoodsRequestVo vo : baseRequestDTO.getProductComboList()) {
                McoffeeComboxGoodsBO productCombox = new McoffeeComboxGoodsBO();
                productCombox.setGoodsId(vo.getSkuId());
                productCombox.setSkuId(vo.getSkuId());
                productCombox.setSpuId(vo.getSpuId());
                productCombox.setQty(vo.getQty());
                List<CartGoodsExtra> extras = mapperFacade.mapAsList(vo.getExtra(), CartGoodsExtra.class);
                List<CartGoodsExtra> specialExtra = mapperFacade.mapAsList(vo.getSpecialExtra(), CartGoodsExtra.class);
                productCombox.setExtra(extras);
                productCombox.setSpecialExtra(specialExtra);
                //加料商品集
                if (CollectionUtils.isNotEmpty(vo.getProductMaterialList())) {
                    List<McoffeeMaterialBO> comboxMaterialGoodsList = new ArrayList<>();
                    for (MaterialRequestVo materialRequestVo : vo.getProductMaterialList()) {
                        McoffeeMaterialBO materialGoods = new McoffeeMaterialBO();
                        materialGoods.setSpuId(materialRequestVo.getSpuId());
                        materialGoods.setCustomerCode(materialRequestVo.getCustomerCode());
                        comboxMaterialGoodsList.add(materialGoods);
                    }
                    productCombox.setProductMaterialList(comboxMaterialGoodsList);
                }
                productComboList.add(productCombox);
            }
        }
        if (CollectionUtils.isNotEmpty(baseRequestDTO.getProductGroupList())) {
            for (ComboxGoodsRequestVo vo : baseRequestDTO.getProductGroupList()) {
                McoffeeComboxGoodsBO productCombox = new McoffeeComboxGoodsBO();
                productCombox.setGoodsId(vo.getSkuId());
                productCombox.setSkuId(vo.getSkuId());
                productCombox.setSpuId(vo.getSpuId());
                productCombox.setQty(vo.getQty());
                List<CartGoodsExtra> extras = mapperFacade.mapAsList(vo.getExtra(), CartGoodsExtra.class);
                List<CartGoodsExtra> specialExtra = mapperFacade.mapAsList(vo.getSpecialExtra(), CartGoodsExtra.class);
                productCombox.setExtra(extras);
                productCombox.setSpecialExtra(specialExtra);
                productCombox.setProductGroupId(StringUtils.isEmpty(vo.getProductGroupId()) ? null : Long.parseLong(vo.getProductGroupId()));
                if(StringUtils.isNotEmpty(vo.getEmptyKey())){
                    productCombox.setGoodsId("0");
                    productCombox.setSkuId("0");
                    productCombox.setSpuId("0");
                    productCombox.setCustomerCode(vo.getEmptyKey());
                    productCombox.setName("无");
                    productCombox.setSpuName("无");
                    productCombox.setSkuName("无");
                    productCombox.setFinalPrice(0L);
                    productCombox.setOriginalPrice(0L);
                    productCombox.setOriginalAmount(0L);
                    productCombox.setAmount(0L);
                    productCombox.setQty(1);
                }
                //加料商品集
                if (CollectionUtils.isNotEmpty(vo.getProductMaterialList())) {
                    List<McoffeeMaterialBO> comboxMaterialGoodsList = new ArrayList<>();
                    for (MaterialRequestVo materialRequestVo : vo.getProductMaterialList()) {
                        McoffeeMaterialBO materialGoods = new McoffeeMaterialBO();
                        materialGoods.setSpuId(materialRequestVo.getSpuId());
                        materialGoods.setGroupId(materialRequestVo.getGroupId());
                        comboxMaterialGoodsList.add(materialGoods);
                    }
                    productCombox.setProductMaterialList(comboxMaterialGoodsList);
                }
                productGroupList.add(productCombox);
            }
        }

        //加料商品集
        if (CollectionUtils.isNotEmpty(baseRequestDTO.getProductMaterialList())) {
            List<McoffeeMaterialBO> materialGoodsList = new ArrayList<>();
            for (MaterialRequestVo materialRequestVo : baseRequestDTO.getProductMaterialList()) {
                McoffeeMaterialBO materialGoods = new McoffeeMaterialBO();
                materialGoods.setSpuId(materialRequestVo.getSpuId());
                materialGoods.setGroupId(materialRequestVo.getGroupId());
                materialGoods.setCustomerCode(materialRequestVo.getCustomerCode());
                materialGoodsList.add(materialGoods);
            }
            mcoffeeProductBO.setProductMaterialList(materialGoodsList);
        }
        mcoffeeProductBO.setProductComboList(productComboList);
        mcoffeeProductBO.setProductGroupList(productGroupList);
        return mcoffeeProductBO;
    }




}
