package cn.freemud.utils;

import cn.freemud.enums.ActivityChannelEnum;
import cn.freemud.enums.CreateOrderType;
import cn.freemud.enums.OrderType;

import java.util.Objects;

public class PropertyConvertUtil {

    public static ActivityChannelEnum orderTypeConvert2ActivityChannel(Integer orderType) {
        if (Objects.equals(CreateOrderType.TAKE_OUT.getCode(), orderType)) {
            return ActivityChannelEnum.delivery;
        } else if (Objects.equals(CreateOrderType.COLLECT_GOODS.getCode(), orderType)) {
            return ActivityChannelEnum.pickup;
        } else if (Objects.equals(CreateOrderType.SAASMALL.getCode(), orderType)) {
            return ActivityChannelEnum.saasmall;
        }else {
            return ActivityChannelEnum.pickup;
        }
    }

    public static ActivityChannelEnum orderTypeEnumConvert2ActivityChannel(Integer orderType) {
        if (Objects.equals(OrderType.TAKE_OUT.getCode(), orderType)) {
            return ActivityChannelEnum.delivery;
        } else if (Objects.equals(OrderType.COLLECT_GOODS.getCode(), orderType) || Objects.equals(OrderType.EAT_IN.getCode(), orderType)) {
            return ActivityChannelEnum.pickup;
        }  else if (Objects.equals(CreateOrderType.SAASMALL.getCode(), orderType)) {
            return ActivityChannelEnum.saasmall;
        }else {
            return ActivityChannelEnum.pickup;
        }
    }
}
