/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: liming.guo
 * @date: 2018/8/10 16:06
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.thirdparty;

import cn.freemud.annotations.IgnoreFeignLogAnnotation;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.*;
import cn.freemud.service.impl.mcoffee.entity.CouponAvailableReq;
import cn.freemud.service.impl.mcoffee.entity.CouponAvailableResp;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

// 测试http://115.159.65.101:8002  线上http://10.51.0.37:8002
@FeignClient(name = "OPEN-STORE-COUPON-ADAPTER-SERVICE",url="${saas.couponadapterclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CouponClient {

    /**
     * 麦咖啡校验券是否可用
     */
    @PostMapping("/mccafe/getCouponsAvailable")
    @IgnoreFeignLogAnnotation(logMessage = "getCouponsAvailable",excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE,messageFieldName=ResponseCodeKeyConstant.MSG)
    CouponAvailableResp getCouponsAvailable(CouponAvailableReq req);


}
