package cn.freemud.service.product;

import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.entities.dto.GetProductInfoDto;
import cn.freemud.entities.dto.ProductInfosDto;
import cn.freemud.entities.dto.product.info.ProductBean;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.service.thirdparty.ProductClient;
import com.freemud.sdk.api.assortment.shoppingcart.constant.CommonsConstant;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author Clover.z
 * @Date 2021/10/29
 * @Desc 商品服务通用能力下沉
 */
@Component
@RequiredArgsConstructor
public class ProductInfoManager {

    private final ProductClient productClient;

    /**
     * 查询商品信息
     * @param partnerId 商户号
     * @param storeCode 门店号
     * @param menuType 菜单类型
     * @param goodsIdList 商品id集合
     * @return
     */
    public List<ProductBean> getProductsInfo(String partnerId,
                                             String storeCode,
                                             String menuType,
                                             List<String> goodsIdList) {
        return this.getProductsInfo(partnerId, storeCode, menuType, false, goodsIdList);
    }

    /**
     * 查询商品信息(可指定查询sku对于spu的信息，不需要spu信息的情况下不要使用）
     * @param partnerId 商户号
     * @param storeCode 门店号
     * @param menuType 菜单类型
     * @param querySkuAttr 是否查询自规格对应spu的属性信息 不需要属性信息就不要传true
     * @param goodsIdList 商品id集合
     * @return
     */
    public List<ProductBean> getProductsInfo(String partnerId,
                                      String storeCode,
                                      String menuType,
                                      Boolean querySkuAttr,
                                      List<String> goodsIdList) {
        if (CollectionUtils.isEmpty(goodsIdList)) {
            return new ArrayList<>();
        }

        //移除空的goodsId及spq的商品券
        goodsIdList = goodsIdList.parallelStream().filter(StringUtils::isNotEmpty).filter(goodsId -> !goodsId.startsWith(CommonsConstant.COUPON_PREFIX)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(goodsIdList)) {
            return new ArrayList<>();
        }

        GetProductInfoDto query = new GetProductInfoDto();
        query.setPartnerId(partnerId);
        query.setShopId(storeCode);
        query.setProductInfoType(2);
        query.setProductIds(goodsIdList);
        query.setChannel(StringUtils.isBlank(menuType) ? "saas" : menuType);
        query.setAutoFillSkuAttr(querySkuAttr);
        ProductInfosDto response = productClient.listProductInfos(query);
        if (null == response || !Objects.equals(ResponseCodeConstant.RESPONSE_SUCCESS, response.getErrcode()) || null == response.getData()) {
            throw new ServiceException(ResponseResult.STORE_ITEM_QUERY_ERROR);
        }
        return CollectionUtils.isEmpty(response.getData().getProducts()) ? new ArrayList<>() : response.getData().getProducts();
    }

}
