/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CouponService
 * @Package cn.freemud.service
 * @Description:
 * @author: pengfei.liu
 * @date: 2020/11/23
 * @version V1.0
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service.active.impl;

import cn.freemud.entities.vo.ShoppingCartInfoRequestVo;
import cn.freemud.service.active.ActiveFactory;
import cn.freemud.service.active.ActiveService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class ActiveFactoryImpl implements ActiveFactory {

    /**
     * coco商户
     */
    @Value("#{'${coco.partnerId}'.split(',')}")
    private List<String> cocoPartnerId;

    /**
     * coco的活动类
     */
    @Autowired
    @Qualifier("cocoActiveService")
    ActiveService CocoActiveServiceImpl;

    /**
     * 平台活动类
     */
    @Autowired
    @Qualifier("platformActiveService")
    ActiveService platformActiveService;

    @Override
    public ActiveService getBuildChooseGoodsService(String partnerId) {

        if(cocoPartnerId.contains(partnerId)){
            return CocoActiveServiceImpl;
        }else{
            return platformActiveService;
        }
    }

    @Override
    public ActiveService getGifAddCartService(String partnerId) {
        if(cocoPartnerId.contains(partnerId)){
            return CocoActiveServiceImpl;
        }else{
            return platformActiveService;
        }
    }
}
