package cn.freemud.manager;


import cn.freemud.entities.db.OpenPlatformWxapp;
import cn.freemud.manager.dao.OpenPlatformWxappDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class OpenPlatformWxappManager {

    @Autowired
    private OpenPlatformWxappDao openPlatformWxappDao;

    public int addOpenPlatformWxapp(OpenPlatformWxapp openPlatformWxapp) {
        return openPlatformWxappDao.insert(openPlatformWxapp);
    }

    public int update(OpenPlatformWxapp openPlatformWxapp) {
        return openPlatformWxappDao.updateByPrimaryKeySelective(openPlatformWxapp);
    }

    public OpenPlatformWxapp findByPartnerIdAndWxappId(String partnerId ,String wxAppid) {
        OpenPlatformWxapp openPlatformWxapp = new OpenPlatformWxapp();
        openPlatformWxapp.setPartnerId(partnerId);
        openPlatformWxapp.setWxAppid(wxAppid);
        return openPlatformWxappDao.selectOne(openPlatformWxapp);
    }

    public List<OpenPlatformWxapp> findByPartnerListId(String partnerId) {
        OpenPlatformWxapp openPlatformWxapp = new OpenPlatformWxapp();
        openPlatformWxapp.setPartnerId(partnerId);
        return openPlatformWxappDao.select(openPlatformWxapp);

    }

    public OpenPlatformWxapp findByWxappId(String wxappId) {
        OpenPlatformWxapp openPlatformWxapp = new OpenPlatformWxapp();
        openPlatformWxapp.setWxAppid(wxappId);
        return openPlatformWxappDao.selectOne(openPlatformWxapp);
    }

    public OpenPlatformWxapp findByAppid(String appid) {
        OpenPlatformWxapp openPlatformWxapp = new OpenPlatformWxapp();
        openPlatformWxapp.setAppid(appid);
        return openPlatformWxappDao.selectOne(openPlatformWxapp);
    }

    /**
     * 通过小程序原始ID查询小程序信息
     * @param userName
     * @return
     */
    public OpenPlatformWxapp findByUserName(String userName) {
        OpenPlatformWxapp openPlatformWxapp = new OpenPlatformWxapp();
        openPlatformWxapp.setUserName(userName);
        return openPlatformWxappDao.selectOne(openPlatformWxapp);
    }
    public int updateMchIdByappId(String wxAppId,String mchId) {
        OpenPlatformWxapp openPlatformWxapp = new OpenPlatformWxapp();
        openPlatformWxapp.setWxAppid(wxAppId);
        openPlatformWxapp.setMchId(mchId);
        return openPlatformWxappDao.updateMchIdByAppId(openPlatformWxapp);
    }

}
