package cn.freemud.handle;

import cn.freemud.entities.dto.BindingCouponTypeDto;
import cn.freemud.entities.dto.coupon.CouponResponseDTO;
import cn.freemud.entities.dto.coupon.FastBatchQueryTemplateInfoRequest;
import cn.freemud.entities.dto.coupon.FastTemplateInfoResponseVO;
import cn.freemud.entities.vo.CouponMsg;
import cn.freemud.service.thirdparty.CouponOnlineClient;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/10/22 下午7:54
 * @description :
 */
@Component
public class GetActivityMsgHandle {

    @Autowired
    private CouponOnlineClient couponOnlineClient;

    /**
     * fisherman 获取 虚拟商品 券数据
     *
     * @param productBindingCoupons
     * @param partnerId
     * @return
     */
    public List<CouponMsg> getCouponData(List<BindingCouponTypeDto> productBindingCoupons, String partnerId) {
        List<CouponMsg> retList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(productBindingCoupons)) {
            // 处理 券数据  这里链路有问题  效率有点低, 后续需要优化
            Set<String> activityCodes = productBindingCoupons.stream()
                    .map(BindingCouponTypeDto::getActivityCode)
                    .collect(Collectors.toSet());
            List<FastTemplateInfoResponseVO> activeDetailVOS = this.batchQueryActivityInfo(activityCodes, partnerId);
            if (CollectionUtils.isNotEmpty(activeDetailVOS)) {
                // 设置 券名称 数量
                Map<String, FastTemplateInfoResponseVO> collect = activeDetailVOS.stream().collect(Collectors.toMap(FastTemplateInfoResponseVO::getTemplateCode, a -> a, (k1, k2) -> k1));
                productBindingCoupons.forEach(coupon -> {
                    CouponMsg msg = new CouponMsg();
                    FastTemplateInfoResponseVO activeDetailVO = collect.get(coupon.getActivityCode());
                    msg.setActivityCode(coupon.getActivityCode());
                    msg.setNum(coupon.getNum());
                    msg.setActivityName(activeDetailVO.getTemplateName());
                    retList.add(msg);
                });
            }
        }
        return retList;
    }

    private List<FastTemplateInfoResponseVO> batchQueryActivityInfo(Set<String> activityCodes, String partnerId) {
        String trackingNo = LogThreadLocal.getTrackingNo();
        FastBatchQueryTemplateInfoRequest request = new FastBatchQueryTemplateInfoRequest();
        request.setPartnerId(partnerId);
        request.setTemplateCode(activityCodes);
        request.setTrackingNo(trackingNo);

        CouponResponseDTO<List<FastTemplateInfoResponseVO>> responseDTO = couponOnlineClient.fastBatchQueryTemplateInfo(request);
        if (responseDTO == null
                || !Objects.equals(responseDTO.getStatusCode(),100)
                || CollectionUtils.isEmpty(responseDTO.getResult())) {
            return null;
        }

        List<FastTemplateInfoResponseVO> result = responseDTO.getResult();
        return result;
    }

}
