/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetProductVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/16 17:35
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import cn.freemud.entities.dto.BindingCouponTypeDto;
import cn.freemud.entities.dto.UserDeliveryInfoDto;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.List;


@Data
public class CreateOrderVo {

    @NotEmpty(message = "sessionId 不能为空")
    private String sessionId;

    @NotEmpty(message = "门店ID 不能为空")
    private String shopId;

    private String partnerId;

    private String storeName;

    private String userId;


    private String userName;


    private String mobile;

    /**
     * 渠道 1 saas 2 img 爱马哥  默认saas
     */
    private String channel;
    /**
     * 订单类型  1 到店自取 2 外卖   枚举CreateOrderType
     */
    @NotNull(message = "下单类型不能为空")
    private Integer orderType;

    /**
     * 到店类型  orderType 传1的时候    如果reachStoreTyp为空转成订单类型4  如果不为空存储4(打包带走)和5（店内就餐）
     */
    private Integer reachStoreType;

    /**
     * 桌号
     */
    private String tableNumber;

    /**
     * 取餐时间
     */
    private String takeMealTime;
    /**
     * 是否外带 ,打包  1 是 0 否
     */
    private Integer takeOut;
    /**
     * 订单备注
     */
    private String orderRemark;
    /**
     * 收货地址ID
     */
    private String receiveId;
    /**
     * 收货办公楼
     */
    private String officeName;
    /**
     * 收货地址
     */
    private String receiveAddress;
    /**
     * 收货用户名
     */
    private String receiveUsername;
    /**
     * 收货电话
     */
    @Pattern(regexp = "^1[3|4|5|6|7|8|9][0-9]{9}$", message = "手机号码格式不正确")
    private String receiveMobile;
    /**
     * 收货人性别 sexType 1 男 2 女 0 未知
     */
    private Integer sex;
    /**
     * 用户定义纬度
     */
    private String latitude;
    /**
     * 用户定义经度
     */
    private String longitude;

    /**
     * 券码
     */
    private String couponCode;
    /**
     * 版本号
     */
    private String version;
    /**
     * form_id  用于金额是0的情况 现在只支持商品券,前端参数
     */
    private String formId;
    /**
     * 用户收货地址信息 ，入参不需要传,通过校验receiveId获取
     */
    public UserDeliveryInfoDto userDeliveryInfoDto;

    @Valid
    private PremiumExchangeActivity premiumExchangeActivity;

    @Data
    public static class PremiumExchangeActivity {
        @NotNull(message = "activityCode 不能为空")
        private String activityCode;
        @NotNull(message = "activityName 不能为空")
        private String activityName;
        /**
         * 加价购sku商品信息
         */
        @Valid
        private List<Product> products;

        @Data
        public static class Product {
            /**
             *  加价购 可能会涉及 虚拟商品  类型 = 9
             */
            private Integer productType;

            /**
             * 虚拟商品 绑定的券信息
             */
            private List<BindingCouponTypeDto> productBindingCouponTypes;

            /**
             * spuId 商品原始id
             */
            @NotNull(message = "spuId不能为空")
            private String spuId;

            /**
             * skuId 如果是多规格 skuId 不能为空
             */
            @NotNull(message = "skuId不能为空")
            private String skuId;
            /**
             * 商品名称
             */
            @NotNull(message = "商品名称不能为空")
            private String skuName;

            @NotNull(message = "商品数量不能为空")
            private Integer qty;

            /**
             * 图片
             */
            private String picture;

            /**
             * 原价 入参不需要传，做对象组装使用
             */
            private Long originalPrice;
            /**
             * 现价 入参不需要传，做对象组装使用
             */
            private Long nowPrice;

            /**
             * 商品状态 入参不需要传，做对象组装使用 （/1下架/2上架/3售罄/4删除/5上架不可售(上架状态但是不在可售时间范围)）
             */
            private Integer status;

            @Valid
            private List<Attribute> attributes;

            @Data
            public static class Attribute {
                /**
                 * 属性ID
                 */
                private String attributeId;

                /**
                 * 属性名称
                 */
                private String attributeValue;
            }
        }

    }
}
