/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartInfoRequestVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/21 21:03
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import java.util.List;

@AllArgsConstructor
@NoArgsConstructor
@Data
@Builder
public class CollageShoppingCartVerRequestVo extends BaseRequestVo {

    @NotEmpty(message = "sessionId不能为空")
    private String sessionId;

    /**
     * 拼单发起人userId（拼单）
     */
    @NotEmpty(message = "拼单发起人不能为空")
    private String createCollageUserId;

    /**
     * 门店
     */
    @NotEmpty(message = "门店不能为空")
    private String storeId;
}
