package cn.freemud.entities.vo;

import lombok.Data;

import java.util.List;

@Data
public class ActivityJoinResponseVo {

    /**
     * 返回结果信息是否有提示
     */
    private int errorCode;

    /**
     * 返回的提示语
     */
    private String errorMsg;

    /**
     * 抬头券名称
     */
    private String name;

    /**
     * 券描述
     */
    private String description;

    /**
     * 券金额
     */
    private Long couponAmount;

    /**
     * 到期时间
     */
    private String endTime;

    /**
     * 活动URL
     */
    private String activityUrl;

    /**
     * 活动规则
     */
    private String activityRule;

    /**
     * 活动样式规则
     */
    private String activityStyleRule;

    /**
     * 优惠券类型 0-商品券 1-代金券 2-折扣券
     */
    private Integer couponType;

    private List<UserCouponBean> userCoupons;

    @Data
    public static class UserCouponBean {
        /**
         * 用户名称
         */
        private String userName;

        /**
         * 用户图片
         */
        private String photoUrl;

        /**
         * 领取时间
         */
        private String startTime;

        /**
         * 券名称
         */
        private String couponName;

        /**
         * 券张数
         */
        private int num;
    }
}
