package cn.freemud.entities.dto.console;

import lombok.Data;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/7/22 下午3:01
 * @description : 业务配置信息
 */
@Data
public class BusinessInfoDTO {

    /**
     * 预约自建外卖制作完成后自动流程时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;
     */
    private Integer appointAutoDeliveryTakeOrderWorkflowFinishTime;

    /**
     * 预约自提单制作完成后自动流程时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;
     */
    private Integer appointAutoSelfmentionMakerWorkflowFinishTime;

    /**
     * 预约自提单接单后自动流程时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;
     */
    private Integer appointAutoSelfmentionTakeOrderWorkflowFinishTime;

    /**
     * 预约自建外卖接单后自动流程时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;
     */
    private Integer appointAutoTakeOutTakeOrderWorkflowFinishTime;

    /**
     * 三方外卖预订单自动拣货完成时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;7:3分钟;8:2分钟;
     */
    private Integer appointThirdDeliveryPickCompleteWorkflowFinishTime;

    /**
     * 预约三方外卖制作完成后自动流程时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;7:3分钟;8:2分钟
     */
    private Integer appointThirdDeliveryTakeOrderWorkflowFinishTime;

    /**
     * 自动退单时间
     */
    private Integer autoChargebackOrderTime;

    /**
     * 退单模式 1手动退单 2自动退单
     */
    private Integer autoChargebackOrderType;

    /**
     * 自建外卖制作完成后自动流程时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;
     */
    private Integer autoDeliveryTakeOrderWorkflowFinishTime;

    /**
     * 自提单制作完成后自动流程时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;
     */
    private Integer autoSelfmentionMakerWorkflowFinishTime;

    /**
     * 自提单接单后自动流程时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;
     */
    private Integer autoSelfmentionTakeOrderWorkflowFinishTime;

    /**
     * 自建外卖接单后自动流程时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;
     */
    private Integer autoTakeOutTakeOrderWorkflowFinishTime;

    /**
     * 三方外卖订单自动拣货完成时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;7:3分钟;8:2分钟
     */
    private Integer autoThirdDeliveryPickCompleteWorkflowFinishTime;

    /**
     * 实时三方外卖制作完成后自动流程时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;7:3分钟;8:2分钟
     */
    private Integer autoThirdDeliveryTakeOrderWorkflowFinishTime;

    /**
     * 是否自动同意退款（同意:1,不同意:0）
     */
    private Integer automaticRefund;

    /**
     * 外卖预约单开关（0:关闭，1:开启）
     */
    private Integer deliveryAppoint;

    /**
     * 外卖预约单时间（分钟） 65分钟、90分钟、120分钟
     */
    private Integer deliveryAppointTime;

    /**
     * 自建外卖订单，商家自配送xx分钟后，订单状态更改为【已完成】
     */
    private Integer deliveryFinishedAfterMinute;
    /**
     * 外卖时间：00:00-23:59
     */
    private String deliveryHours;
    /**
     * 外卖预订单提醒时间{1:15分钟;2:30分钟;3:45分钟;4:60分钟;5:5分钟;6:10分钟}
     */
    private String deliveryOrderWarnTime;
    /**
     * 自建外卖订单-实时单，商家自配送，门店接单xx分钟后，订单状态变更为配送中
     */
    private Integer deliveryProcessingAfterMinute;
    /**
     * 自建外卖订单-预约单，商家自配送，预约商家前xx分钟，订单更改为配送中
     */
    private Integer deliveryProcessingBeforeMinute;
    /**
     * 预计送达时间（分钟）
     */
    private Integer expectedTime;
    /**
     * 商品平均制作时常（分钟）
     */
    private Integer goodsAvgTimeOfMaking;
    /**
     * 是否支持发票 1是 0否
     */
    private Integer invoice;
    /**
     * 发票特殊说明
     */
    private String invoiceExplain;
    /**
     * 是否支持自动接单(1是2否)
     */
    private Integer isAutoTakeOrder;
    /**
     * 最大接单量,单位笔
     */
    private Integer maxOrderQuantity;
    /**
     * 可开票的最小价格
     */
    private Integer minPriceForInvoice;
    /**
     * 预订单打印时间{1：提醒时打印；2：接单时打印}
     */
    private String orderPrintConfig;
    /**
     * 订单进度条，1 开启，2 关闭
     */
    private Integer orderProgressBarStatus;
    /**
     * 点餐方式(,隔开)：pickup,delivery
     */
    private String orderType;
    /**
     * 预订单提醒时间{1:15分钟;2:30分钟;3:45分钟;4:60分钟;5:5分钟;6:10分钟}
     */
    private String orderWarnTime;
    /**
     * 超时关单 1开启 2关闭
     */
    private Integer overTimeCloseOrder;
    /**
     * 接单超时关单时间，默认30分钟
     */
    private Integer overTimeCloseOrderTime;
    /**
     * 自提-服务端自动接单时间 1:立即;2:1分钟;3:5分钟（顾客下单XX后，订单状态自动更改为已接单）
     */
    private Integer pickupAutomaticOrderTime;
    /**
     * 自提预约单开关（0:关闭，1:开启）
     */
    private Integer selfMentionSwitch;
    /**
     * 是否需要餐具 1 需要 0 不需要
     */
    private Integer tableware;
    /**
     * 参与结算（1：是、2：否）
     */
    private Integer takePartInSettleAccounts;
    /**
     * 外卖-服务端自动接单时间 1:立即;2:1分钟;3:5分钟（顾客下单XX后，订单状态自动更改为已接单）
     */
    private Integer takeoutAutomaticOrderTime;

    /**
     * 所属商户号
     */
    private String partnerId;

    /**
     * 退款时间，time_type_of_refund 为1时格式为HH:mm:ss，为2时默认48小时
     */
    private String timeOfRefund;

    /**
     * 退款时间类型:1指定时间，2默认48小时后
     */
    private Integer timeTypeOfRefund;

    /**
     * 开启制作时间 1 ：是 ， 2 ：否
     */
    private Integer turnOnTimeOfMaking;

    /**
     *  拓展业务字段
     */
    private ExpandFieldsDTO expandFields;
}
