package cn.freemud.entities.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.freemud.application.sdk.api.couponcenter.backstage.domain.ActiveChannel;
import com.freemud.application.sdk.api.couponcenter.online.domain.ActiveGroupVO;
import com.freemud.application.sdk.api.couponcenter.online.domain.CouponProductVO;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class GetCouponDetailResponseDto {
    /**
     *表示接口处理是否成功，1表示成功，0表示失败
     */
    private Integer result;
    private Integer statusCode;
    private Integer ver;
    private List<Errors> errors;
    private List<Details> details;
    @Data
    public static class Details{
        private String code;
        private String activeCode;
        private String title;
        private Integer type;
        //type=0时，subType=1为黑名单，否则为白名单
        private Integer subType;
        private Integer status;
        private String create_time;
        private String redeem_time;
        private String valid_start;
        private String valid_ends;
        private String minAmount;
        private Integer storeChannelLimit;
        private Active active;
        private List<ActiveProduct> activeProduct;
        //活动门店限制（非发券指定门店活动使用）
        private List<ActiveRestrictionVOS> activeRestrictionVOS;
        /**
         * 可核销周,时间段设置
         */
        private List<ActiveRedeemTimeInterval> activeRedeemTimeIntervalList;
        private Integer today_available_times;



//        private String code;
//        private String activeCode;
//        private String title;
//        private Integer type;
//        private Integer status;
//        private String create_time;
//        private String redeem_time;
//        private Integer storeChannelLimit;
//        private String valid_start;
//        private String valid_ends;
//        private Integer minAmount;
        private String sendReason;
        private String cancelReason;
//        private Active active;
//        private List<ActiveRestrict> activeRestrictionVOS;
        private List<ActiveProductSetting> activeProductSetting;
//        private List<ActiveProduct> activeProduct;
        private List<ActiveGroupVO> activeGroupVOS;
        private List<CouponProductVO> couponProductList;
        private List<ActiveChannel> activeChannels;
//        private List<ActiveRedeemTimeIntervalVO> activeRedeemTimeIntervalList;
        private Integer storeLimitLevel;
        //为0可用
        private Integer storelimit;
        private String limitStoreId;
//        private Integer today_available_times;
        private Integer total_available_times;
        private Integer maxRedeemTime;
        private Integer availableTimes;
        private Integer dailyRedeemTime;
        private Integer dailyAvailableTimes;
    }
    @Data
    public static class Active{
        @JsonProperty("ActiveCode")
        private String activeCode;
        @JsonProperty("ActiveDesc")
        private String activeDesc;
        @JsonProperty("ActiveName")
        private String activeName;
        @JsonProperty("BusinessID")
        private Integer businessId;
        @JsonProperty("CreateDate")
        private String createDate;
        @JsonProperty("CreateUser")
        private String createUser;
        @JsonProperty("EBCode")
        private String ebCode;
        @JsonProperty("EndDate")
        private String endDate;
        @JsonProperty("EndString")
        private String endString;
        @JsonProperty("Inventory")
        private Integer inventory;
        @JsonProperty("LastEditDate")
        private String lastEditDate;
        @JsonProperty("LastEditUser")
        private String lastEditUser;
        @JsonProperty("MaxDiscount")
        private Integer maxDiscount;
        @JsonProperty("MaxRedeemTimes")
        private Integer maxRedeemTimes;
        @JsonProperty("MinAmount")
        private Integer minAmount;
        @JsonProperty("PartnerID")
        private String partnerId;
        @JsonProperty("PercentDiscount")
        private Integer percentDiscount;
        @JsonProperty("Percentage")
        private Integer percentage;
        @JsonProperty("PromotionType")
        private String promotionType;
        @JsonProperty("ShouldRedeemAll")
        private Boolean shouldRedeemAll;
        @JsonProperty("StartDate")
        private String startDate;
        @JsonProperty("StartString")
        private String startString;
        @JsonProperty("State")
        private Integer state;
        @JsonProperty("Type")
        private Integer type;
    }
    @Data
    public static class ActiveProduct{
        @JsonProperty("ActiveID")
        private Integer activeId;
        @JsonProperty("Amount")
        private Integer amount;
        @JsonProperty("Paid")
        private Integer paid;
        @JsonProperty("Price_Discount")
        private BigDecimal priceDiscount;
        @JsonProperty("Price_Original")
        private BigDecimal priceOriginal;
        @JsonProperty("Product")
        private String product;
        @JsonProperty("ProductID")
        private Integer productId;
        @JsonProperty("ProductID_Partner")
        private String productIdPartner;
        @JsonProperty("Remain")
        private Integer remain;
    }
    @Data
    public static class ActiveProductSetting{
    }
    @Data
    public static class ActiveRestrictionVOS{
        @JsonProperty("ActiveID")
        private String activeId;
        @JsonProperty("City")
        private String city;
        @JsonProperty("StoreIDPartner")
        private String storeIdPartner;
    }
    @Data
    public static class Errors{
        @JsonProperty("error_code")
        private String errorCode;
        private String parameter;
    }
    @Data
    public static class ActiveRedeemTimeInterval{

        private Long id;
        private Integer partnerid;
        private Integer activeid;
        /**
         * 启用时间 时分秒
         */
        private String begintime;
        /**
         * 结束时间 时分秒
         */
        private String endtime;
        private Integer status;
        private Date createdate;
        private String createuser;
        /**
         * 周几可用, 7位数字,第一位为周日
         */
        private String weekday;
        /**
         * 限制使用日期, 年-月-, 多个竖线分割,仅在列表内的日期可用
         */
        private String limitdates;


    }
}
