package cn.freemud.entities.dto;

import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: CouponListDto
 * @Package cn.freemud.entities.dto
 * @Description: 简单描述下这个类是做什么用的
 * @author: biao.zhang
 * @date: 2018/10/15 16:07
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class CouponListResponseDto {

    /**
     * 版本号
     */
    private Integer ver;

    /**
     * 状态码
     */
    private String statusCode;

    /**
     * 状态码描述
     */
    private String msg;

    private List<CouponBean> result;

    @Data
    public static class CouponBean {
        /**
         * 门店ID
         */
        private String storeId;
        /**
         * 优惠券名称
         */
        private String activityName;
        /**
         * 优惠券描述
         */
        private String activityDesc;
        /**
         * 券码
         */
        private String couponCode;
        /**
         * 优惠券金额(单位分)
         */
        private Integer discountAmount;
        /**
         * 使用门槛（单位分，0表示无门槛）
         */
        private Integer thresholdAmount;
        /**
         * 手机号
         */
        private String mobile;
        /**
         * 用户ID
         */
        private String userId;
        /**
         * 券有效期开始时间
         */
        private Long validityPeriodStart;
        /**
         * 券有效期结束时间
         */
        private Long validityPeriodEnd;
        /**
         * 是否已使用 : 0未使用  1已使用
         */
        private Integer isUsed;
        /**
         * 优惠券类型，0：商品券 1：代金券 3-折扣券
         */
        private Integer type;

        private CouponActivity activity;

        @Data
        public static class CouponActivity {
            /**
             * 0-不共享，1-共享
             */
            private Integer isShared;
        }

    }
}
