package cn.freemud.entities.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import javax.validation.constraints.NotNull;
import java.util.List;

@NoArgsConstructor
@Data
@AllArgsConstructor
@Builder
public class ActivityQueryRequestDto {
    /**
     * 接口版本
     */
    private String ver;
    /**
     * 商户号
     */
    private String partnerCode;
    /**
     * 商家门店编号
     */
    private String storeId;

    /**
     * 门店的组织机构树
     */
    private List<String> orgIds;

    /**
     * 区域
     */
    private String area;
    /**
     * 多个活动code
     */
    private List<String> activityCodes;
    /**
     * 渠道 pickup-到店取餐 deliver-外卖
     */
    private String channel;
    /**
     * 绑定的小程序id
     */
    private String appId;
    /**
     * 活动类型
     * 1-整单满减
     * 11-每满减
     * 12-阶梯满减
     * 2-单品特价
     * 21-单品折扣
     * 3-优惠券
     * 5-整单满金额折
     * 51-每满金额折
     * 52-阶梯满金额折
     * 53-第M件/杯N折
     * 6-买M赠N
     * 7-满额赠券
     * 8-满N件换购
     * 81-满额换购
     * 82-满额阶梯换购（满多少金额，加价换购）
     * 100-阶梯满数量打折
     * 101-整单满数量打折
     * 不传查询所有活动
     */
    private Integer activityType;

    /**
     * 活动类型集合，传入此字段后，activityType字段不再起作用
     */
    private List<Integer> activityTypes;
    /**
     * 用户id，传入该参数会过滤掉该用户已领取了的活动（适用于优惠券活动列表）
     */
    private String userId;

    /**
     * 接入方名称，主要用于使用不同的模板
     * i应用传isaas，快中台传fast
     */
    private String application;
    /**
     *活动时间段列表 0：不需要返回
     */
    private Integer isShowTime;
    /**
     *活动动限制商品列表 0：不需要返回 其他：需要返回
     */
    private Integer isShowGoods;
    /**
     *活动赠送商品列表 0：不需要返回 其他：需要返回
     */
    private Integer isShowSendGoods;
    /**
     *活动赠送券列表 0：不需要返回 其他：需要返回
     */
    private Integer isShowSendCoupon;
    /**
     *活动周期送列表 0：不需要返回 其他：需要返回
     */
    private Integer isShowCycles;
    /**
     *活动优惠信息列表 0：不需要返回 其他：需要返回
     */
    private Integer isShowBenefit;
    /**
     * 活动门店白名单列表 0：不需要返回 其他：需要返回
     */
    private Integer isShowStore;

    /**
     * 商品渠道 查询商品信息时用
     * saas-自提 saasdelivery-外卖  saasmall-微商城 ....
     */
    @ApiModelProperty(value = "商品渠道 saas(开个店自提)、saasdelivery（开个店外卖）、saasmall（微商城）、wc（围餐）、mtwm（美团外卖）、jdwm（京东外卖）、fmwd（非码微店）、eleme（饿了么外卖）、ebwm（饿百外卖） 有换购或者赠送商品的活动时必传")
    private String productChannel;


    private List<QueryGoodsBeanDto> goods;

    @Data
    @RequiredArgsConstructor
    public static class QueryGoodsBeanDto {
        /**
         * 商品ID
         */
        @NotNull
        private String goodsId;
        /**
         * 商品数量
         */
        @NotNull
        private Integer goodsQuantity;
        /**
         * 原价
         */
        @NotNull
        private Long originalPrice;

        public QueryGoodsBeanDto(String goodsId,Integer goodsQuantity, Long originalPrice){
            this.goodsId = goodsId;
            this.goodsQuantity = goodsQuantity;
            this.originalPrice = originalPrice;
        }
    }

}
