package cn.freemud.entities.db;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "open_platform_wxapp_plugin_bind")
public class OpenPlatformWxappPluginBind {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 插件基础表id
     */
    @Column(name = "plugin_id")
    private Long pluginId;

    /**
     * 插件appid
     */
    @Column(name = "plugin_appid")
    private String pluginAppid;


    /**
     * 微信appid
     */
    @Column(name = "wx_appid")
    private String wxAppid;

    /**
     * 品牌ID
     */
    @Column(name = "partner_id")
    private String partnerId;

    /**
     * 插件状态（1：申请中，2：申请通过，3：被拒绝；4：已超时）
     */
    @Column(name = "audit_status")
    private Integer auditStatus;

    /**
     * 操作状态（0:禁用，1：启用）
     */
    @Column(name = "operate_status")
    private Integer operateStatus;

    /**
     * 微信支付平台活动id
     */
    @Column(name = "wechat_act_id")
    private Integer wechatActId;

    /**
     * 创建时间
     */
    @Column(name = "gmt_created")
    private Date gmtCreated;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;

}