package cn.freemud.demo.service.impl;

import cn.freemud.demo.entities.bo.SendGoods;
import cn.freemud.demo.entities.bo.goods.CheckCartRequest;
import cn.freemud.demo.entities.bo.goods.ShoppingCartContext;
import cn.freemud.demo.entities.bo.goods.list.ListCartGoodsBO;
import cn.freemud.demo.entities.dto.goods.add.list.BaseListCartGoodsVO;
import cn.freemud.demo.service.ShoppingCartService;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.entities.vo.PremiumExchangeResponseVo;
import cn.freemud.entities.vo.ShoppingCartGoodsBaseResponseVo;
import cn.freemud.service.impl.AssortmentSdkService;
import com.alibaba.fastjson.JSONObject;
import com.freemud.sdk.api.assortment.shoppingcart.service.impl.ShoppingCartBaseServiceImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class ShoppingBaseServiceImpl implements ShoppingCartService {

    @Autowired
    private AssortmentSdkService assortmentSdkService;

    @Autowired
    private ShoppingCartBaseServiceImpl shoppingCartBaseService;

    @Override
    public List<CartGoods> updateAndGetShoppingCart(List<CartGoods> cartGoodsList, CartGoods cartGoods, ShoppingCartContext cartContext) {

        List<CartGoods> nowCartGoodsList = new ArrayList<>();
        //判断当前商品在购物车是否已存在,存在则数量＋1,不存在商品行 + 1
        cartGoodsList.forEach(oldCartGoods -> {
            int index;
            if ((index = nowCartGoodsList.indexOf(oldCartGoods)) >= 0) {
                nowCartGoodsList.get(index).setQty(nowCartGoodsList.get(index).getQty() + cartGoods.getQty());
            } else {
                nowCartGoodsList.add(oldCartGoods);
            }
        });
        // 重新set购物车信息到缓存中
        assortmentSdkService.setShoppingCart(cartContext.getPartnerId(), cartContext.getShopId(),
                cartContext.getUserId(), nowCartGoodsList, cartContext.getSessionId(), cartContext.getTableNumber(), this.shoppingCartBaseService,null);
        cartGoodsList.clear();
        cartGoodsList.addAll(nowCartGoodsList);
        return nowCartGoodsList;

    }

    @Override
    public CheckCartRequest checkShoppingCart(List<CartGoods> cartGoodsList, CartGoods cartGoods, ShoppingCartContext cartContext) {

        ShoppingCartGoodsBaseResponseVo shoppingCartGoodsResponseVo = new ShoppingCartGoodsBaseResponseVo();
        if (cartGoods != null){
            cartGoodsList.add(cartGoods);
        }


        //当商品全部添加完毕,校验购物车商品(是否合法,上下架,点餐方式,是否在当前菜单中...),并移除非法商品
        cn.freemud.entities.dto.product.CheckCartRequest checkCartRequest = assortmentSdkService.checkShoppingCartSdk(cartGoodsList, cartContext.getPartnerId(),
                cartContext.getShopId(), shoppingCartGoodsResponseVo, cartContext.getOrderType(),
                "", cartContext.getMenuType(), shoppingCartBaseService);

        CheckCartRequest result = JSONObject.parseObject(JSONObject.toJSONString(checkCartRequest), CheckCartRequest.class);
        result.setChanged(checkCartRequest.getShoppingCartGoodsResponseVo().getChanged());
        result.setToastMsg(checkCartRequest.getShoppingCartGoodsResponseVo().getToastMsg());

        return result;
    }

    @Override
    public void updateForPopupWindow(BaseListCartGoodsVO baseListCartGoodsVO, Integer showType, List<PremiumExchangeResponseVo.PremiumExchangeProduct> chooseSendGoodList, List<SendGoods> sendGoods) {
        if (Integer.valueOf("5").equals(showType) && !org.springframework.util.CollectionUtils.isEmpty(chooseSendGoodList)) {
            chooseSendGoodList.forEach(good -> {
                SendGoods first = null;
                first = sendGoods.stream().filter(a -> a.getGoodsId().equals(good.getSkuId()) || a.getGoodsId().equals(good.getSpuId())).findFirst().orElse(null);
                if (first == null) return;
                CartGoods cartGoods = new CartGoods();
                cartGoods.setSpuId(good.getSpuId());
                cartGoods.setSkuId(good.getSkuId());
                cartGoods.setSkuName(good.getSkuName());
                cartGoods.setOriginalAmount(good.getOriginalPrice());
                cartGoods.setFinalPrice(good.getNowPrice());
                cartGoods.setOriginalAmount(good.getOriginalPrice());
                cartGoods.setAmount(good.getNowPrice());
                cartGoods.setPhotoUrl(good.getPicture());
                cartGoods.setGoodsId(good.getPid());
                cartGoods.setName(good.getName());
                cartGoods.setSpuName(good.getSpuName());
                cartGoods.setQty(first == null ? 1 : first.getQty());
                cartGoods.setActivityCode(first.getActivityCode());
                if (!CollectionUtils.isEmpty(first.getAttributes())) {
                    List<CartGoods.CartGoodsExtra> extra = new ArrayList();
                    first.getAttributes().forEach(attribute -> {
                        CartGoods.CartGoodsExtra goodsExtra = new CartGoods.CartGoodsExtra();
                        goodsExtra.setAttributeId(attribute.getAttributeId());
                        goodsExtra.setAttributeName(attribute.getAttributeValue());
                        extra.add(goodsExtra);
                    });
                    cartGoods.setExtra(extra);
                }
                baseListCartGoodsVO.getProducts().add(cartGoods);
            });
        }
    }
}
