package cn.freemud.demo.manager.customer;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.demo.adapter.manager.CustomerBO2DTOAdapter;
import cn.freemud.demo.adapter.manager.CustomerDTO2BOAdapter;
import cn.freemud.demo.entities.bo.goods.QueryReceiveAddressByIdBO;
import cn.freemud.demo.entities.bo.goods.ReceiveAddressBO;
import cn.freemud.demo.entities.bo.member.*;
import cn.freemud.entities.dto.GetPaidRuleRequestDto;
import cn.freemud.entities.dto.GetPaidRuleResponseDto;
import cn.freemud.entities.dto.user.GetSessionUserInfoDto;
import cn.freemud.entities.dto.user.GetUserScoreUseDetailRequest;
import cn.freemud.entities.dto.user.GetUserScoreUserDetailResponse;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.service.thirdparty.CustomerApplicationClient;
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo;
import com.freemud.api.assortment.datamanager.manager.customer.AssortmentCustomerInfoManager;
import com.freemud.application.sdk.api.constant.FMStatusCode;
import com.freemud.application.sdk.api.log.ErrorLog;
import com.freemud.application.sdk.api.membercenter.request.QueryReceiveAddressRequest;
import com.freemud.application.sdk.api.membercenter.response.QueryReceiveAddressResponse;
import com.freemud.application.sdk.api.membercenter.service.MemberCenterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("KgdCustomerService")
public class KgdCustomerServceImpl implements CustomerService {

    @Autowired
    private CustomerApplicationClient customerApplicationClient;

    @Autowired
    private CustomerApplicationClient customScoreClient;

    @Autowired
    private MemberCenterService memberCenterService;
    @Autowired
    private CustomerDTO2BOAdapter customerDTO2BOAdapter;
    @Autowired
    private CustomerBO2DTOAdapter customerBO2DTOAdapter;
    @Autowired
    private AssortmentCustomerInfoManager customerInfoManager;
    @Override
    public CustomerInfo getUserInfoByUserId(String sessionId) {
        GetSessionUserInfoDto getSessionUserInfoDto = new GetSessionUserInfoDto();
        getSessionUserInfoDto.setIsGetPaid(true);
        getSessionUserInfoDto.setSessionId(sessionId);
        // BaseResponse<CustomerInfoVo> sessionUserInfo =
        // customerApplicationClient.getSessionUserInfo(getSessionUserInfoDto);
        // if (!ResponseResult.SUCCESS.getCode().equals(sessionUserInfo.getCode()) || sessionUserInfo.getResult() ==
        // null) {
        // throw new ServiceException(ResponseResult.NOT_LOGIN);
        // }
        AssortmentCustomerInfoVo customerInfoVo = customerInfoManager.getCustomerInfoByObject(sessionId);
        if (customerInfoVo == null)
            throw new ServiceException(ResponseResult.NOT_LOGIN);
        // CustomerInfoVo result = sessionUserInfo.getResult();
        CustomerInfo customerInfo = new CustomerInfo();

        // if(CollectionUtils.isEmpty(result.getMemberPaids())){
        // customerInfo.setIsMember(false);
        // } else {
        // boolean isMember = result.getMemberPaids().stream().anyMatch(item -> item.getExpiryTime().getTime() >
        // System.currentTimeMillis());
        // customerInfo.setIsMember(isMember);
        //
        // }
        customerInfo.setUserId(customerInfoVo.getMemberId());
        customerInfo.setIsMember(customerInfoVo.isMemberPaid());
        return customerInfo;
    }

    @Override
    public ReceiveAddressBO queryReceiveAddressById(QueryReceiveAddressByIdBO queryReceiveAddressByIdBO) {
        QueryReceiveAddressRequest request = new QueryReceiveAddressRequest(queryReceiveAddressByIdBO.getAddressId(), queryReceiveAddressByIdBO.getPartnerId());
        com.freemud.application.sdk.api.base.BaseResponse<QueryReceiveAddressResponse> queryReceiveAddressResponse = memberCenterService.queryReceiveAddressById(request, "");
        if (!ResponseResult.SUCCESS.getCode().equals(queryReceiveAddressResponse.getCode()) || queryReceiveAddressResponse.getData() == null) {
            throw new ServiceException(ResponseResult.USER_GETRECEIVEADDRESS_ERROR);
        }
        ReceiveAddressBO receiveAddressBO = customerDTO2BOAdapter.convert2StoreInfoBO(queryReceiveAddressResponse.getData());
        return receiveAddressBO;


    }

    @Override
    public UserScoreUserDetailBO getUserScoreUseDetail(GetUserScoreUseDetailBO getUserScoreUseDetailBO) {
        GetUserScoreUseDetailRequest request = customerBO2DTOAdapter.convert2GetUserScoreUseDetailRequest(getUserScoreUseDetailBO);
        UserScoreUserDetailBO userScoreUserDetailBO = null;
        GetUserScoreUserDetailResponse userScoreUseDetail = null;
        try {
            // 加入try catch是为了custom服务挂掉，购物车服务可以也可以正常
            userScoreUseDetail = customerApplicationClient.getUserScoreUseDetail(request);
        } catch (Exception ex) {
            ErrorLog.errorConvertJson(this.getClass(),"getUserScoreUseDetailError",ex);
        }
        if (userScoreUseDetail != null && userScoreUseDetail.getCode().equals(FMStatusCode.SUCCESS.getCode()) && userScoreUseDetail.getResult() != null) {
            userScoreUserDetailBO = customerDTO2BOAdapter.convert2UserScoreUserDetailBO(userScoreUseDetail);

        }
        return userScoreUserDetailBO;
    }

    @Override
    public PaidRuleResponseBO getPaidRule(GetPaidRuleRequestBO getPaidRuleRequestBO) {
        GetPaidRuleRequestDto getPaidRuleRequestDto = customerBO2DTOAdapter.convert2GetPaidRuleRequestDto(getPaidRuleRequestBO);
        BaseResponse<GetPaidRuleResponseDto> baseResponse = customerApplicationClient.getPaidRule(getPaidRuleRequestDto);
        if (baseResponse == null || !ResponseResult.SUCCESS.getCode().equals(baseResponse.getCode()) || baseResponse.getResult() == null
                || baseResponse.getResult().getActivityPrice() == null) {
            return null;
        }
        PaidRuleResponseBO paidRuleResponseBO = customerDTO2BOAdapter.convert2PaidRuleResponseBO(baseResponse.getResult());
        return paidRuleResponseBO;
    }
}
