package cn.freemud.demo.entities.dto;

import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

@Data
public class BaseRequestDTO {

    private String sessionId;
    /**
     * 商户Id
     */
    @NotEmpty(message = "partnerId不能为空")
    private String partnerId;
    /**
     * 门店Id
     * 商城没有门店id，如果需要门店id必传在业务中进行校验
     */
    //@NotEmpty(message = "shopId不能为空")
    private String shopId;

    /**
     * 下单类型 CreateOrderType 外卖、到店、商城
     */
    private Integer orderType;

    /**
     * 渠道类型 OrderChannelType
     */
    private String channelType;

}
