package cn.freemud.demo.entities.bo.goods;

import lombok.Data;

import java.util.List;

@Data
public class ComboxGoodsBO {

    /**
     * 麦咖啡多规格商品spuid
     */
    private String spuId;

    private String skuId;
    private Integer qty;
    private String goodsId;

    /**
     * 商品组Id
     */
    private Long productGroupId;

    /**
     * 第三方商品编号
     */
    private String customerCode;

    /**
     * 购物车一行商品的名称
     */
    private String name;

    /**
     * 商品的spuName
     */
    private String spuName;

    /**
     * 商品的skuName
     */
    private String skuName;

    /**
     * 购物车一行商品的现单价
     */
    private Long finalPrice;
    /**
     * 购物车一行商品的原单机
     */
    private Long originalPrice;
    /**
     * 购物车一行商品的原价
     */
    private Long originalAmount;
    /**
     * 购物车一行商品的现价
     */
    private Long amount;


    /**
     * 麦咖啡空键位
     */
    private String emptyKey;
    /**
     * 商品额外的属性
     */
    List<CartGoodsExtra> extra;

    /**
     * 商品额外的属性
     */
    List<CartGoodsExtra>  specialExtra;

    /**
     * 麦咖啡多规格商品加料
     */
    private List<McoffeeMaterialBO> productMaterialList;

}
