package cn.freemud.controller;


import cn.freemud.monitorcenter.tools.HealthUtil;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AgentController {

    @ApiAnnotation
    @RequestMapping(value = "/agent/check")
    public String reportDefault() {
        return HealthUtil.healthCheck();
    }

    /**
     * 提供给健康检查使用
     * 不可删除，如删除后会造成健康检查失败而重启服务
     * @return
     */
    @ApiAnnotation
    @RequestMapping(value = "/health/check")
    public String checkHealth() {
        return "ok";
    }
}


