/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ResponseCodeKeyConstant
 * @Package cn.freemud.constant
 * @Description:
 * @author: song.cai
 * @date: 2019/1/15 17:20
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.constant;

import com.alibaba.fastjson.JSONObject;

import java.util.HashSet;
import java.util.Set;

public class ResponseCodeKeyConstant {
    public final static String CODE = "code";

    public final static String MESSAGE = "message";

    public final static String STATUS_CODE = "statusCode";

    public static final String MEG = "meg";

    public static final String MSG = "msg";

    /**
     *  code名称来源根据 ProductInfosDto
     */
    public final static String ERR_CODE = "errcode";

    /**
     * errmsg名称来源根据 ProductInfosDto
     */
    public static final String ERR_MSG = "errmsg";



    private final static Set<String> responseCodeKeySet = new HashSet<>();

    static {
        responseCodeKeySet.add(CODE);
        responseCodeKeySet.add(ERR_CODE);
        responseCodeKeySet.add(STATUS_CODE);
    }

    public static Object getResponseCodeValue(JSONObject jsonObject) {
        Object o = null;
        for (String key : responseCodeKeySet) {
            if ((o = jsonObject.get(key)) != null) {
                break;
            }
        }
        return o;
    }


}
